/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.workflow;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.PackageStats;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.charsets.UTF8;
import edu.umd.cs.findbugs.util.Util;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.CheckForNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileBugHash {
    Map<String, StringBuilder> hashes = new LinkedHashMap<String, StringBuilder>();
    Map<String, Integer> counts = new HashMap<String, Integer>();
    Map<String, Integer> sizes = new HashMap<String, Integer>();
    MessageDigest digest = Util.getMD5Digest();

    FileBugHash(BugCollection bugs) {
        for (PackageStats pStat : bugs.getProjectStats().getPackageStats()) {
            for (PackageStats.ClassStats cStat : pStat.getSortedClassStats()) {
                String path = cStat.getName();
                path = path.indexOf(46) == -1 ? cStat.getSourceFile() : path.substring(0, path.lastIndexOf(46) + 1).replace('.', '/') + cStat.getSourceFile();
                this.counts.put(path, 0);
                Integer size = this.sizes.get(path);
                if (size == null) {
                    size = 0;
                }
                this.sizes.put(path, size + cStat.size());
            }
        }
        for (BugInstance bug : bugs.getCollection()) {
            SourceLineAnnotation source = bug.getPrimarySourceLineAnnotation();
            String packagePath = source.getPackageName().replace('.', '/');
            String key = packagePath.length() == 0 ? source.getSourceFile() : packagePath + "/" + source.getSourceFile();
            StringBuilder buf = this.hashes.get(key);
            if (buf == null) {
                buf = new StringBuilder();
                this.hashes.put(key, buf);
            }
            buf.append(bug.getInstanceKey()).append("-").append(source.getStartLine()).append(".").append(source.getStartBytecode()).append(" ");
            Integer count = this.counts.get(key);
            if (count == null) {
                this.counts.put(key, 1);
                continue;
            }
            this.counts.put(key, 1 + count);
        }
    }

    public Collection<String> getSourceFiles() {
        return this.counts.keySet();
    }

    @CheckForNull
    public String getHash(String sourceFile) {
        StringBuilder rawHash = this.hashes.get(sourceFile);
        if (rawHash == null || this.digest == null) {
            return null;
        }
        byte[] data = this.digest.digest(UTF8.getBytes(rawHash.toString()));
        String tmp = new BigInteger(1, data).toString(16);
        if (tmp.length() < 32) {
            tmp = "000000000000000000000000000000000".substring(0, 32 - tmp.length()) + tmp;
        }
        return tmp;
    }

    public int getBugCount(String sourceFile) {
        Integer count = this.counts.get(sourceFile);
        if (count == null) {
            return 0;
        }
        return count;
    }

    public int getSize(String sourceFile) {
        Integer size = this.sizes.get(sourceFile);
        if (size == null) {
            return 0;
        }
        return size;
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 1 || args.length > 0 && "-help".equals(args[0])) {
            System.err.println("Usage: " + FileBugHash.class.getName() + " [<infile>]");
            System.exit(1);
        }
        SortedBugCollection origCollection = new SortedBugCollection();
        int argCount = 0;
        if (argCount == args.length) {
            origCollection.readXML(System.in);
        } else {
            origCollection.readXML(args[argCount]);
        }
        FileBugHash result = FileBugHash.compute(origCollection);
        for (String sourceFile : result.getSourceFiles()) {
            System.out.println(result.getHash(sourceFile) + "\t" + sourceFile);
        }
    }

    public static FileBugHash compute(BugCollection origCollection) {
        return new FileBugHash(origCollection);
    }
}

