package de.ugoe.cs.quest.usageprofiles;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

import de.ugoe.cs.quest.eventcore.Event;
import de.ugoe.cs.quest.usageprofiles.TrieBasedModel;

public class MockTrieBasedModel extends TrieBasedModel {
	private static final long serialVersionUID = 1L;

	public MockTrieBasedModel(int markovOrder, Random r) {
		super(markovOrder, r);
	}

	@Override
	public double getProbability(List<Event> context,
			Event symbol) {
		List<Event> list = new ArrayList<Event>();
		if( context.isEmpty() ) {
			return 2;
		}
		list.add(context.get(context.size()-1));
		if( trie.find(list).getFollowingSymbols().contains(symbol) ) {
			return 1;
		} else {
			return 0;
		}
	}
}