package de.ugoe.cs.quest.tasktrees.temporalrelation;

import org.junit.Test;

import de.ugoe.cs.quest.eventcore.gui.KeyPressed;
import de.ugoe.cs.quest.eventcore.gui.KeyReleased;
import de.ugoe.cs.quest.eventcore.guimodel.IGUIElement;
import de.ugoe.cs.quest.eventcore.guimodel.ITextField;
import de.ugoe.cs.quest.tasktrees.testutils.DummyGUIElement;
import de.ugoe.cs.quest.tasktrees.testutils.TaskTreeChecker;
import de.ugoe.cs.tasktree.keyboardmaps.VirtualKey;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: 28.04.2012$
 * @author 2012, last modified by $Author: patrick$
 */
public class DefaultTextInputReductionRuleTest extends AbstractTemporalRelationshipTC {

    /**
     *
     */
    @Test
    public void testSimpleTextEntry() {
        IGUIElement element1 = new DummyTextField("elem1");
        simulateEvent(new KeyPressed(VirtualKey.LETTER_A), element1);
        simulateEvent(new KeyReleased(VirtualKey.LETTER_A), element1);
        new TaskTreeChecker(true).assertTaskTree
            ("Sequence sequence0 {" +
             "  TextInputEvent TextInput a {" +
             "    Event KeyPressed LETTER_A {}" +
             "    Event KeyReleased LETTER_A {}" +
             "  }" +
             "}", getTaskTree());

        simulateEvent(new KeyPressed(VirtualKey.LETTER_B), element1);
        simulateEvent(new KeyReleased(VirtualKey.LETTER_B), element1);
        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence0 {" +
             "  TextInputEvent TextInput ab {" +
             "    Event KeyPressed LETTER_A {}" +
             "    Event KeyReleased LETTER_A {}" +
             "    Event KeyPressed LETTER_B {}" +
             "    Event KeyReleased LETTER_B {}" +
             "  }" +
             "}", getTaskTree());

        simulateEvent(new KeyPressed(VirtualKey.SHIFT), element1);
        simulateEvent(new KeyPressed(VirtualKey.LETTER_C), element1);
        simulateEvent(new KeyReleased(VirtualKey.LETTER_C), element1);
        simulateEvent(new KeyReleased(VirtualKey.SHIFT), element1);
        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence0 {" +
             "  TextInputEvent TextInput abC {" +
             "    Event KeyPressed LETTER_A {}" +
             "    Event KeyReleased LETTER_A {}" +
             "    Event KeyPressed LETTER_B {}" +
             "    Event KeyReleased LETTER_B {}" +
             "    Event KeyPressed SHIFT {}" +
             "    Event KeyPressed LETTER_C {}" +
             "    Event KeyReleased LETTER_C {}" +
             "    Event KeyReleased SHIFT {}" +
             "  }" +
             "}", getTaskTree());

        simulateEvent(new KeyPressed(VirtualKey.SHIFT), element1);
        simulateEvent(new KeyPressed(VirtualKey.LETTER_D), element1);
        simulateEvent(new KeyReleased(VirtualKey.LETTER_D), element1);
        simulateEvent(new KeyPressed(VirtualKey.LETTER_E), element1);
        simulateEvent(new KeyReleased(VirtualKey.LETTER_E), element1);
        simulateEvent(new KeyPressed(VirtualKey.LETTER_F), element1);
        simulateEvent(new KeyReleased(VirtualKey.LETTER_F), element1);
        simulateEvent(new KeyReleased(VirtualKey.SHIFT), element1);
        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence0 {" +
             "  TextInputEvent TextInput abCDEF {" +
             "    Event KeyPressed LETTER_A {}" +
             "    Event KeyReleased LETTER_A {}" +
             "    Event KeyPressed LETTER_B {}" +
             "    Event KeyReleased LETTER_B {}" +
             "    Event KeyPressed SHIFT {}" +
             "    Event KeyPressed LETTER_C {}" +
             "    Event KeyReleased LETTER_C {}" +
             "    Event KeyReleased SHIFT {}" +
             "    Event KeyPressed SHIFT {}" +
             "    Event KeyPressed LETTER_D {}" +
             "    Event KeyReleased LETTER_D {}" +
             "    Event KeyPressed LETTER_E {}" +
             "    Event KeyReleased LETTER_E {}" +
             "    Event KeyPressed LETTER_F {}" +
             "    Event KeyReleased LETTER_F {}" +
             "    Event KeyReleased SHIFT {}" +
             "  }" +
             "}", getTaskTree());

        simulateEvent(new KeyPressed(VirtualKey.SHIFT), element1);
        simulateEvent(new KeyPressed(VirtualKey.SHIFT), element1);
        simulateEvent(new KeyPressed(VirtualKey.LETTER_G), element1);
        simulateEvent(new KeyReleased(VirtualKey.LETTER_G), element1);
        simulateEvent(new KeyReleased(VirtualKey.SHIFT), element1);
        simulateEvent(new KeyReleased(VirtualKey.SHIFT), element1);
        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence0 {" +
             "  TextInputEvent TextInput abCDEFg {" +
             "    Event KeyPressed LETTER_A {}" +
             "    Event KeyReleased LETTER_A {}" +
             "    Event KeyPressed LETTER_B {}" +
             "    Event KeyReleased LETTER_B {}" +
             "    Event KeyPressed SHIFT {}" +
             "    Event KeyPressed LETTER_C {}" +
             "    Event KeyReleased LETTER_C {}" +
             "    Event KeyReleased SHIFT {}" +
             "    Event KeyPressed SHIFT {}" +
             "    Event KeyPressed LETTER_D {}" +
             "    Event KeyReleased LETTER_D {}" +
             "    Event KeyPressed LETTER_E {}" +
             "    Event KeyReleased LETTER_E {}" +
             "    Event KeyPressed LETTER_F {}" +
             "    Event KeyReleased LETTER_F {}" +
             "    Event KeyReleased SHIFT {}" +
             "    Event KeyPressed SHIFT {}" +
             "    Event KeyPressed SHIFT {}" +
             "    Event KeyPressed LETTER_G {}" +
             "    Event KeyReleased LETTER_G {}" +
             "    Event KeyReleased SHIFT {}" +
             "    Event KeyReleased SHIFT {}" +
             "  }" +
             "}", getTaskTree());

    }

    /**
     *
     */
    @Test
    public void testTextEntryOnDifferentGuiElements() {
        IGUIElement element1 = new DummyTextField("elem1");
        IGUIElement element2 = new DummyTextField("elem2");
        simulateEvent(new KeyPressed(VirtualKey.LETTER_A), element1);
        simulateEvent(new KeyReleased(VirtualKey.LETTER_A), element1);
        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence0 {" +
             "  TextInputEvent TextInput a {" +
             "    Event KeyPressed LETTER_A {}" +
             "    Event KeyReleased LETTER_A {}" +
             "  }" +
             "}", getTaskTree());

        simulateEvent(new KeyPressed(VirtualKey.LETTER_B), element2);
        simulateEvent(new KeyReleased(VirtualKey.LETTER_B), element2);
        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence0 {" +
             "  Sequence sequence1 {" +
             "    TextInputEvent TextInput a {" +
             "      Event KeyPressed LETTER_A {}" +
             "      Event KeyReleased LETTER_A {}" +
             "    }" +
             "  }" +
             "  Sequence sequence2 {" +
             "    TextInputEvent TextInput b {" +
             "      Event KeyPressed LETTER_B {}" +
             "      Event KeyReleased LETTER_B {}" +
             "    }" +
             "  }" +
             "}", getTaskTree());

        simulateEvent(new KeyPressed(VirtualKey.SHIFT), element1);
        simulateEvent(new KeyPressed(VirtualKey.LETTER_C), element1);
        simulateEvent(new KeyReleased(VirtualKey.LETTER_C), element1);
        simulateEvent(new KeyReleased(VirtualKey.SHIFT), element1);
        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence0 {" +
             "  Sequence sequence1 {" +
             "    TextInputEvent TextInput a {" +
             "      Event KeyPressed LETTER_A {}" +
             "      Event KeyReleased LETTER_A {}" +
             "    }" +
             "  }" +
             "  Sequence sequence2 {" +
             "    TextInputEvent TextInput b {" +
             "      Event KeyPressed LETTER_B {}" +
             "      Event KeyReleased LETTER_B {}" +
             "    }" +
             "  }" +
             "  Sequence sequence3 {" +
             "    TextInputEvent TextInput C {" +
             "      Event KeyPressed SHIFT {}" +
             "      Event KeyPressed LETTER_C {}" +
             "      Event KeyReleased LETTER_C {}" +
             "      Event KeyReleased SHIFT {}" +
             "    }" +
             "  }" +
             "}", getTaskTree());

        simulateEvent(new KeyPressed(VirtualKey.SHIFT), element2);
        simulateEvent(new KeyPressed(VirtualKey.LETTER_D), element2);
        simulateEvent(new KeyReleased(VirtualKey.LETTER_D), element2);
        simulateEvent(new KeyPressed(VirtualKey.LETTER_E), element2);
        simulateEvent(new KeyReleased(VirtualKey.LETTER_E), element2);
        simulateEvent(new KeyPressed(VirtualKey.LETTER_F), element2);
        simulateEvent(new KeyReleased(VirtualKey.LETTER_F), element2);
        simulateEvent(new KeyReleased(VirtualKey.SHIFT), element2);
        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence0 {" +
             "  Sequence sequence1 {" +
             "    TextInputEvent TextInput a {" +
             "      Event KeyPressed LETTER_A {}" +
             "      Event KeyReleased LETTER_A {}" +
             "    }" +
             "  }" +
             "  Sequence sequence2 {" +
             "    TextInputEvent TextInput b {" +
             "      Event KeyPressed LETTER_B {}" +
             "      Event KeyReleased LETTER_B {}" +
             "    }" +
             "  }" +
             "  Sequence sequence3 {" +
             "    TextInputEvent TextInput C {" +
             "      Event KeyPressed SHIFT {}" +
             "      Event KeyPressed LETTER_C {}" +
             "      Event KeyReleased LETTER_C {}" +
             "      Event KeyReleased SHIFT {}" +
             "    }" +
             "  }" +
             "  Sequence sequence4 {" +
             "    TextInputEvent TextInput DEF {" +
             "      Event KeyPressed SHIFT {}" +
             "      Event KeyPressed LETTER_D {}" +
             "      Event KeyReleased LETTER_D {}" +
             "      Event KeyPressed LETTER_E {}" +
             "      Event KeyReleased LETTER_E {}" +
             "      Event KeyPressed LETTER_F {}" +
             "      Event KeyReleased LETTER_F {}" +
             "      Event KeyReleased SHIFT {}" +
             "    }" +
             "  }" +
             "}", getTaskTree());

        simulateEvent(new KeyPressed(VirtualKey.SHIFT), element1);
        simulateEvent(new KeyPressed(VirtualKey.SHIFT), element1);
        simulateEvent(new KeyPressed(VirtualKey.LETTER_G), element1);
        simulateEvent(new KeyReleased(VirtualKey.LETTER_G), element1);
        simulateEvent(new KeyReleased(VirtualKey.SHIFT), element1);
        simulateEvent(new KeyReleased(VirtualKey.SHIFT), element1);
        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence0 {" +
             "  Sequence sequence1 {" +
             "    TextInputEvent TextInput a {" +
             "      Event KeyPressed LETTER_A {}" +
             "      Event KeyReleased LETTER_A {}" +
             "    }" +
             "  }" +
             "  Sequence sequence2 {" +
             "    TextInputEvent TextInput b {" +
             "      Event KeyPressed LETTER_B {}" +
             "      Event KeyReleased LETTER_B {}" +
             "    }" +
             "  }" +
             "  Sequence sequence3 {" +
             "    TextInputEvent TextInput C {" +
             "      Event KeyPressed SHIFT {}" +
             "      Event KeyPressed LETTER_C {}" +
             "      Event KeyReleased LETTER_C {}" +
             "      Event KeyReleased SHIFT {}" +
             "    }" +
             "  }" +
             "  Sequence sequence4 {" +
             "    TextInputEvent TextInput DEF {" +
             "      Event KeyPressed SHIFT {}" +
             "      Event KeyPressed LETTER_D {}" +
             "      Event KeyReleased LETTER_D {}" +
             "      Event KeyPressed LETTER_E {}" +
             "      Event KeyReleased LETTER_E {}" +
             "      Event KeyPressed LETTER_F {}" +
             "      Event KeyReleased LETTER_F {}" +
             "      Event KeyReleased SHIFT {}" +
             "    }" +
             "  }" +
             "  Sequence sequence5 {" +
             "    TextInputEvent TextInput g {" +
             "      Event KeyPressed SHIFT {}" +
             "      Event KeyPressed SHIFT {}" +
             "      Event KeyPressed LETTER_G {}" +
             "      Event KeyReleased LETTER_G {}" +
             "      Event KeyReleased SHIFT {}" +
             "      Event KeyReleased SHIFT {}" +
             "    }" +
             "  }" +
             "}", getTaskTree());

    }

    /**
     *
     */
    @Test
    public void testUsageOfBackspace() {
        IGUIElement element1 = new DummyTextField("elem1");
        simulateEvent(new KeyPressed(VirtualKey.LETTER_A), element1);
        simulateEvent(new KeyReleased(VirtualKey.LETTER_A), element1);
        simulateEvent(new KeyPressed(VirtualKey.LETTER_B), element1);
        simulateEvent(new KeyReleased(VirtualKey.LETTER_B), element1);
        simulateEvent(new KeyPressed(VirtualKey.LETTER_C), element1);
        simulateEvent(new KeyReleased(VirtualKey.LETTER_C), element1);
        simulateEvent(new KeyPressed(VirtualKey.LETTER_D), element1);
        simulateEvent(new KeyReleased(VirtualKey.LETTER_D), element1);
        simulateEvent(new KeyPressed(VirtualKey.BACK_SPACE), element1);
        simulateEvent(new KeyReleased(VirtualKey.BACK_SPACE), element1);
        simulateEvent(new KeyPressed(VirtualKey.LETTER_E), element1);
        simulateEvent(new KeyReleased(VirtualKey.LETTER_E), element1);
        simulateEvent(new KeyPressed(VirtualKey.LETTER_F), element1);
        simulateEvent(new KeyReleased(VirtualKey.LETTER_F), element1);
        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence0 {" +
             "  TextInputEvent TextInput abcef {" +
             "    Event KeyPressed LETTER_A {}" +
             "    Event KeyReleased LETTER_A {}" +
             "    Event KeyPressed LETTER_B {}" +
             "    Event KeyReleased LETTER_B {}" +
             "    Event KeyPressed LETTER_C {}" +
             "    Event KeyReleased LETTER_C {}" +
             "    Event KeyPressed LETTER_D {}" +
             "    Event KeyReleased LETTER_D {}" +
             "    Event KeyPressed BACK_SPACE {}" +
             "    Event KeyReleased BACK_SPACE {}" +
             "    Event KeyPressed LETTER_E {}" +
             "    Event KeyReleased LETTER_E {}" +
             "    Event KeyPressed LETTER_F {}" +
             "    Event KeyReleased LETTER_F {}" +
             "  }" +
             "}", getTaskTree());

        simulateEvent(new KeyPressed(VirtualKey.BACK_SPACE), element1);
        simulateEvent(new KeyReleased(VirtualKey.BACK_SPACE), element1);
        simulateEvent(new KeyPressed(VirtualKey.BACK_SPACE), element1);
        simulateEvent(new KeyReleased(VirtualKey.BACK_SPACE), element1);
        simulateEvent(new KeyPressed(VirtualKey.BACK_SPACE), element1);
        simulateEvent(new KeyReleased(VirtualKey.BACK_SPACE), element1);
        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence0 {" +
             "  TextInputEvent TextInput ab {" +
             "    Event KeyPressed LETTER_A {}" +
             "    Event KeyReleased LETTER_A {}" +
             "    Event KeyPressed LETTER_B {}" +
             "    Event KeyReleased LETTER_B {}" +
             "    Event KeyPressed LETTER_C {}" +
             "    Event KeyReleased LETTER_C {}" +
             "    Event KeyPressed LETTER_D {}" +
             "    Event KeyReleased LETTER_D {}" +
             "    Event KeyPressed BACK_SPACE {}" +
             "    Event KeyReleased BACK_SPACE {}" +
             "    Event KeyPressed LETTER_E {}" +
             "    Event KeyReleased LETTER_E {}" +
             "    Event KeyPressed LETTER_F {}" +
             "    Event KeyReleased LETTER_F {}" +
             "    Event KeyPressed BACK_SPACE {}" +
             "    Event KeyReleased BACK_SPACE {}" +
             "    Event KeyPressed BACK_SPACE {}" +
             "    Event KeyReleased BACK_SPACE {}" +
             "    Event KeyPressed BACK_SPACE {}" +
             "    Event KeyReleased BACK_SPACE {}" +
             "  }" +
             "}", getTaskTree());

    }

    /**
     *
     */
    private static class DummyTextField extends DummyGUIElement implements ITextField {

        /**  */
        private static final long serialVersionUID = 1L;

        /**
         * TODO: comment
         * 
         * @param name
         */
        public DummyTextField(String name) {
            super(name);
        }

    }

}
