package de.ugoe.cs.quest.plugin.php.eventcore;

import java.util.List;

import de.ugoe.cs.quest.eventcore.IEventType;

/**
 * <p>
 * Event type for PHP web requests.
 * </p>
 * 
 * @version $Revision: $ $Date: Aug 16, 2012$
 * @author 2012, last modified by $Author: sherbold$
 */
public class PHPEventType implements IEventType {

    /**
     * <p>
     * Id for object serialization.
     * </p>
     */
    private static final long serialVersionUID = 1L;

    /**
     * <p>
     * Path of the web request.
     * </p>
     */
    private String path;

    /**
     * <p>
     * List of post variable names posted with the request.
     * </p>
     */
    private List<String> postVars;

    /**
     * <p>
     * List of get variable names posted with the request.
     * </p>
     */
    private List<String> getVars;

    /**
     * <p>
     * Constructor. Creates a new PHPEventType from a given path, a list of post variables, and a
     * list of get variables.
     * </p>
     * 
     * @param path
     *            path of the URI of the event
     * @param postVars
     *            POST variables send with the event
     * @param getVars
     *            GET variables send with the event
     */
    public PHPEventType(String path, List<String> postVars, List<String> getVars) {
        this.path = path;
        this.postVars = postVars;
        this.getVars = getVars;
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.quest.eventcore.IEventType#getName()
     */
    @Override
    public String getName() {
        return "PHPEventType";
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        String str = path;
        if (getVars != null && !getVars.isEmpty()) {
            str += "+GET" + getVars.toString().replace(" ", "");
        }
        if (postVars != null && !postVars.isEmpty()) {
            str += "+POST" + postVars.toString().replace(" ", "");
        }
        return str;
    }

}
