/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.guitar.model;

import edu.umd.cs.guitar.model.GIDGenerator;
import edu.umd.cs.guitar.model.data.AttributesType;
import edu.umd.cs.guitar.model.data.ComponentType;
import edu.umd.cs.guitar.model.data.ContainerType;
import edu.umd.cs.guitar.model.data.GUIStructure;
import edu.umd.cs.guitar.model.data.GUIType;
import edu.umd.cs.guitar.model.data.ObjectFactory;
import edu.umd.cs.guitar.model.data.PropertyType;
import edu.umd.cs.guitar.model.wrapper.GUITypeWrapper;
import java.util.ArrayList;
import java.util.List;

public class DefaultIDGenerator
implements GIDGenerator {
    static ObjectFactory factory = new ObjectFactory();
    static final int prime = 31;
    private List<String> properties;

    protected DefaultIDGenerator(List<String> properties) {
        this.properties = properties;
    }

    @Override
    public void generateID(GUIStructure gs) {
        for (GUIType gui : gs.getGUI()) {
            this.generateGUIID(gui);
        }
    }

    private void generateGUIID(GUIType gui) {
        ContainerType container = gui.getContainer();
        if (container == null) {
            return;
        }
        long windowHashCode = this.getWindowHashCode(gui);
        this.generateComponentID(container, windowHashCode);
    }

    private long getWindowHashCode(GUIType gui) {
        GUITypeWrapper wGUI = new GUITypeWrapper(gui);
        String title = wGUI.getTitle();
        long hashcode = title.hashCode();
        hashcode = hashcode * 2L & 0xFFFFFFFFL;
        return hashcode;
    }

    private void generateComponentID(ComponentType component, long parentHashCode) {
        AttributesType attributes = component.getAttributes();
        long hashcode = 1L;
        if (attributes != null) {
            long localHashCode = this.getLocalHashcode(component);
            hashcode = parentHashCode * 31L + localHashCode;
            hashcode = hashcode * 2L & 0xFFFFFFFFL;
            String sID = "w" + hashcode;
            PropertyType property = factory.createPropertyType();
            property.setName("ID");
            property.getValue().add(sID);
            attributes.getProperty().add(0, property);
        } else {
            hashcode = parentHashCode;
        }
        if (component instanceof ContainerType) {
            ContainerType container = (ContainerType)component;
            List<ComponentType> children = container.getContents().getWidgetOrContainer();
            boolean isAddIndex = !this.hasUniqueChildren(component);
            for (ComponentType child : children) {
                long propagatedHashCode = hashcode;
                if (isAddIndex) {
                    propagatedHashCode = 31L * propagatedHashCode + (long)Integer.valueOf(children.indexOf(child)).hashCode();
                }
                this.generateComponentID(child, propagatedHashCode);
            }
        }
    }

    private boolean hasUniqueChildren(ComponentType component) {
        if (!(component instanceof ContainerType)) {
            return true;
        }
        ArrayList<Long> examinedHashCode = new ArrayList<Long>();
        ContainerType container = (ContainerType)component;
        for (ComponentType child : container.getContents().getWidgetOrContainer()) {
            long hashcode = this.getLocalHashcode(child);
            if (examinedHashCode.contains(hashcode)) {
                return false;
            }
            examinedHashCode.add(hashcode);
        }
        return true;
    }

    private long getLocalHashcode(ComponentType component) {
        int prime = 31;
        long hashcode = 1L;
        AttributesType attributes = component.getAttributes();
        if (attributes == null) {
            return hashcode;
        }
        List<PropertyType> lProperty = attributes.getProperty();
        if (lProperty == null) {
            return hashcode;
        }
        for (PropertyType property : lProperty) {
            if (!this.properties.contains(property.getName())) continue;
            String name = property.getName();
            hashcode = 31L * hashcode + (long)(name == null ? 0 : name.hashCode());
            List<String> valueList = property.getValue();
            if (valueList == null) continue;
            for (String value : valueList) {
                hashcode = 31L * hashcode + (long)(value == null ? 0 : value.hashCode());
            }
        }
        hashcode = hashcode * 2L & 0xFFFFFFFFL;
        return hashcode;
    }
}

