/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list;

import cern.colt.Arrays;
import cern.colt.Sorting;
import cern.colt.function.ByteComparator;
import cern.colt.function.ByteProcedure;
import cern.colt.list.AbstractList;
import cern.colt.list.ByteArrayList;
import cern.jet.random.Uniform;
import cern.jet.random.engine.DRand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

public abstract class AbstractByteList
extends AbstractList {
    protected int size;

    protected AbstractByteList() {
    }

    public void add(byte by) {
        this.beforeInsert(this.size, by);
    }

    public void addAllOfFromTo(AbstractByteList abstractByteList, int n, int n2) {
        this.beforeInsertAllOfFromTo(this.size, abstractByteList, n, n2);
    }

    public void beforeInsert(int n, byte by) {
        this.beforeInsertDummies(n, 1);
        this.set(n, by);
    }

    public void beforeInsertAllOfFromTo(int n, AbstractByteList abstractByteList, int n2, int n3) {
        int n4 = n3 - n2 + 1;
        this.beforeInsertDummies(n, n4);
        this.replaceFromToWithFrom(n, n + n4 - 1, abstractByteList, n2);
    }

    protected void beforeInsertDummies(int n, int n2) {
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        if (n2 > 0) {
            this.ensureCapacity(this.size + n2);
            this.setSizeRaw(this.size + n2);
            this.replaceFromToWithFrom(n + n2, this.size - 1, this, n);
        }
    }

    public int binarySearch(byte by) {
        return this.binarySearchFromTo(by, 0, this.size - 1);
    }

    public int binarySearchFromTo(byte by, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        while (n3 <= n4) {
            int n5 = (n3 + n4) / 2;
            byte by2 = this.get(n5);
            if (by2 < by) {
                n3 = n5 + 1;
                continue;
            }
            if (by2 > by) {
                n4 = n5 - 1;
                continue;
            }
            return n5;
        }
        return -(n3 + 1);
    }

    public Object clone() {
        return this.partFromTo(0, this.size - 1);
    }

    public boolean contains(byte by) {
        return this.indexOfFromTo(by, 0, this.size - 1) >= 0;
    }

    public void delete(byte by) {
        int n = this.indexOfFromTo(by, 0, this.size - 1);
        if (n >= 0) {
            this.remove(n);
        }
    }

    public byte[] elements() {
        byte[] byArray = new byte[this.size];
        int n = this.size;
        while (--n >= 0) {
            byArray[n] = this.getQuick(n);
        }
        return byArray;
    }

    public AbstractByteList elements(byte[] byArray) {
        this.clear();
        this.addAllOfFromTo(new ByteArrayList(byArray), 0, byArray.length - 1);
        return this;
    }

    public abstract void ensureCapacity(int var1);

    public boolean equals(Object object) {
        if (!(object instanceof AbstractByteList)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        AbstractByteList abstractByteList = (AbstractByteList)object;
        if (this.size() != abstractByteList.size()) {
            return false;
        }
        int n = this.size();
        while (--n >= 0) {
            if (this.getQuick(n) == abstractByteList.getQuick(n)) continue;
            return false;
        }
        return true;
    }

    public void fillFromToWith(int n, int n2, byte by) {
        AbstractByteList.checkRangeFromTo(n, n2, this.size);
        int n3 = n;
        while (n3 <= n2) {
            this.setQuick(n3++, by);
        }
    }

    public boolean forEach(ByteProcedure byteProcedure) {
        int n = 0;
        while (n < this.size) {
            if (byteProcedure.apply(this.get(n++))) continue;
            return false;
        }
        return true;
    }

    public byte get(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        return this.getQuick(n);
    }

    protected abstract byte getQuick(int var1);

    public int indexOf(byte by) {
        return this.indexOfFromTo(by, 0, this.size - 1);
    }

    public int indexOfFromTo(byte by, int n, int n2) {
        AbstractByteList.checkRangeFromTo(n, n2, this.size);
        for (int i = n; i <= n2; ++i) {
            if (by != this.getQuick(i)) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(byte by) {
        return this.lastIndexOfFromTo(by, 0, this.size - 1);
    }

    public int lastIndexOfFromTo(byte by, int n, int n2) {
        AbstractByteList.checkRangeFromTo(n, n2, this.size());
        for (int i = n2; i >= n; --i) {
            if (by != this.getQuick(i)) continue;
            return i;
        }
        return -1;
    }

    public void mergeSortFromTo(int n, int n2) {
        int n3 = this.size();
        AbstractByteList.checkRangeFromTo(n, n2, n3);
        byte[] byArray = this.elements();
        Sorting.mergeSort(byArray, n, n2 + 1);
        this.elements(byArray);
        this.setSizeRaw(n3);
    }

    public void mergeSortFromTo(int n, int n2, ByteComparator byteComparator) {
        int n3 = this.size();
        AbstractByteList.checkRangeFromTo(n, n2, n3);
        byte[] byArray = this.elements();
        Sorting.mergeSort(byArray, n, n2 + 1, byteComparator);
        this.elements(byArray);
        this.setSizeRaw(n3);
    }

    public AbstractByteList partFromTo(int n, int n2) {
        AbstractByteList.checkRangeFromTo(n, n2, this.size);
        int n3 = n2 - n + 1;
        ByteArrayList byteArrayList = new ByteArrayList(n3);
        byteArrayList.addAllOfFromTo(this, n, n2);
        return byteArrayList;
    }

    public void quickSortFromTo(int n, int n2) {
        int n3 = this.size();
        AbstractByteList.checkRangeFromTo(n, n2, n3);
        byte[] byArray = this.elements();
        java.util.Arrays.sort(byArray, n, n2 + 1);
        this.elements(byArray);
        this.setSizeRaw(n3);
    }

    public void quickSortFromTo(int n, int n2, ByteComparator byteComparator) {
        int n3 = this.size();
        AbstractByteList.checkRangeFromTo(n, n2, n3);
        byte[] byArray = this.elements();
        Sorting.quickSort(byArray, n, n2 + 1, byteComparator);
        this.elements(byArray);
        this.setSizeRaw(n3);
    }

    public boolean removeAll(AbstractByteList abstractByteList) {
        int n;
        if (abstractByteList.size() == 0) {
            return false;
        }
        int n2 = abstractByteList.size() - 1;
        int n3 = 0;
        for (n = 0; n < this.size; ++n) {
            if (abstractByteList.indexOfFromTo(this.getQuick(n), 0, n2) >= 0) continue;
            this.setQuick(n3++, this.getQuick(n));
        }
        n = n3 != this.size ? 1 : 0;
        this.setSize(n3);
        return n != 0;
    }

    public void removeFromTo(int n, int n2) {
        int n3;
        AbstractByteList.checkRangeFromTo(n, n2, this.size);
        int n4 = this.size - n2 - 1;
        if (n4 > 0) {
            this.replaceFromToWithFrom(n, n - 1 + n4, this, n2 + 1);
        }
        if ((n3 = n2 - n + 1) > 0) {
            this.setSizeRaw(this.size - n3);
        }
    }

    public void replaceFromToWithFrom(int n, int n2, AbstractByteList abstractByteList, int n3) {
        block4: {
            int n4 = n2 - n + 1;
            if (n4 <= 0) break block4;
            AbstractByteList.checkRangeFromTo(n, n2, this.size());
            AbstractByteList.checkRangeFromTo(n3, n3 + n4 - 1, abstractByteList.size());
            if (n <= n3) {
                while (--n4 >= 0) {
                    this.setQuick(n++, abstractByteList.getQuick(n3++));
                }
            } else {
                int n5 = n3 + n4 - 1;
                while (--n4 >= 0) {
                    this.setQuick(n2--, abstractByteList.getQuick(n5--));
                }
            }
        }
    }

    public void replaceFromToWithFromTo(int n, int n2, AbstractByteList abstractByteList, int n3, int n4) {
        int n5;
        if (n3 > n4) {
            throw new IndexOutOfBoundsException("otherFrom: " + n3 + ", otherTo: " + n4);
        }
        if (this == abstractByteList && n2 - n != n4 - n3) {
            this.replaceFromToWithFromTo(n, n2, this.partFromTo(n3, n4), 0, n4 - n3);
            return;
        }
        int n6 = n5 = n4 - n3 + 1;
        int n7 = n - 1;
        if (n2 >= n) {
            n6 -= n2 - n + 1;
            n7 = n2;
        }
        if (n6 > 0) {
            this.beforeInsertDummies(n7 + 1, n6);
        } else if (n6 < 0) {
            this.removeFromTo(n7 + n6, n7 - 1);
        }
        if (n5 > 0) {
            this.replaceFromToWithFrom(n, n + n5 - 1, abstractByteList, n3);
        }
    }

    public void replaceFromWith(int n, Collection collection) {
        AbstractByteList.checkRange(n, this.size());
        Iterator iterator = collection.iterator();
        int n2 = n;
        int n3 = Math.min(this.size() - n, collection.size());
        for (int i = 0; i < n3; ++i) {
            this.set(n2++, ((Number)iterator.next()).byteValue());
        }
    }

    public boolean retainAll(AbstractByteList abstractByteList) {
        int n;
        if (abstractByteList.size() == 0) {
            if (this.size == 0) {
                return false;
            }
            this.setSize(0);
            return true;
        }
        int n2 = abstractByteList.size() - 1;
        int n3 = 0;
        for (n = 0; n < this.size; ++n) {
            if (abstractByteList.indexOfFromTo(this.getQuick(n), 0, n2) < 0) continue;
            this.setQuick(n3++, this.getQuick(n));
        }
        n = n3 != this.size ? 1 : 0;
        this.setSize(n3);
        return n != 0;
    }

    public void reverse() {
        int n = this.size() / 2;
        int n2 = this.size() - 1;
        int n3 = 0;
        while (n3 < n) {
            byte by = this.getQuick(n3);
            this.setQuick(n3++, this.getQuick(n2));
            this.setQuick(n2--, by);
        }
    }

    public void set(int n, byte by) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        this.setQuick(n, by);
    }

    protected abstract void setQuick(int var1, byte var2);

    protected void setSizeRaw(int n) {
        this.size = n;
    }

    public void shuffleFromTo(int n, int n2) {
        AbstractByteList.checkRangeFromTo(n, n2, this.size());
        Uniform uniform = new Uniform(new DRand(new Date()));
        for (int i = n; i < n2; ++i) {
            int n3 = uniform.nextIntFromTo(i, n2);
            byte by = this.getQuick(n3);
            this.setQuick(n3, this.getQuick(i));
            this.setQuick(i, by);
        }
    }

    public int size() {
        return this.size;
    }

    public AbstractByteList times(int n) {
        ByteArrayList byteArrayList = new ByteArrayList(n * this.size());
        int n2 = n;
        while (--n2 >= 0) {
            byteArrayList.addAllOfFromTo(this, 0, this.size() - 1);
        }
        return byteArrayList;
    }

    public ArrayList toList() {
        int n = this.size();
        ArrayList<Byte> arrayList = new ArrayList<Byte>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(new Byte(this.get(i)));
        }
        return arrayList;
    }

    public String toString() {
        return Arrays.toString(this.partFromTo(0, this.size() - 1).elements());
    }
}

