package de.ugoe.cs.quest.plugin.mfc.guimodel;

import de.ugoe.cs.quest.eventcore.guimodel.AbstractDefaultGUIElement;
import de.ugoe.cs.quest.eventcore.guimodel.IGUIElementSpec;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: $
 * @author 2011, last modified by $Author: $
 */
public abstract class MFCGUIElement extends AbstractDefaultGUIElement {
    
    /**  */
    private static final long serialVersionUID = 1L;

    /**
     * @param name
     * @param id
     * @param isModal
     */
    public MFCGUIElement(MFCGUIElementSpec specification, MFCGUIElement parent) {
        super(specification, parent);
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.quest.eventcore.IEventTarget#getPlatform()
     */
    @Override
    public String getPlatform() {
        return "MFC";
    }

    /**
     * @return Returns the id.
     */
    public String getId() {
        return Long.toString(((MFCGUIElementSpec) super.getSpecification()).getHwnd());
    }

    /**
     * @return Returns the name.
     */
    public String getType() {
        return ((MFCGUIElementSpec) super.getSpecification()).getType();
    }

    /**
     * @return Returns the name.
     */
    public String getName() {
        return ((MFCGUIElementSpec) super.getSpecification()).getName();
    }

    /**
     * @return Returns the isModal.
     */
    public boolean isModal() {
        return ((MFCGUIElementSpec) super.getSpecification()).isModal();
    }

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @return
     */
    public int getResourceId() {
        return ((MFCGUIElementSpec) super.getSpecification()).getResourceId();
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.quest.eventcore.guimodel.IGUIElement#updateSpecification(de.ugoe.cs.quest.eventcore.guimodel.IGUIElementSpec)
     */
    @Override
    public void updateSpecification(IGUIElementSpec furtherSpec) {
        ((MFCGUIElementSpec) super.getSpecification()).update(furtherSpec);
    }

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return super.getSpecification().toString();
    }

    /**
     * <p>
     * TODO: comment
     * </p>
     */
    public String toXML() {
        if (getParent() != null) {
            return
                ((MFCGUIElement) getParent()).toXML() +
                ((MFCGUIElementSpec) super.getSpecification()).toXML();
        }
        else {
            return ((MFCGUIElementSpec) super.getSpecification()).toXML();
        }
    }
}
