package de.ugoe.cs.quest.tasktrees.temporalrelation;

import org.junit.Test;

import de.ugoe.cs.quest.eventcore.IEventTarget;
import de.ugoe.cs.quest.tasktrees.testutils.DummyGUIElement;
import de.ugoe.cs.quest.tasktrees.testutils.DummyInteraction;
import de.ugoe.cs.quest.tasktrees.testutils.TaskTreeChecker;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: $
 * @author 2011, last modified by $Author: $
 */
public class DefaultGuiEventSequenceDetectionRuleTest extends AbstractTemporalRelationshipTC {
    
    /**
     *
     */
    @Test
    public void testOneInteractionOnOneElement() {
        simulateEvent(new DummyInteraction("bla", 1), new DummyGUIElement("elem1"));

        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence {" +
             "  Event bla {}" +
             "}", getTaskTree());
    }

    /**
     *
     */
    @Test
    public void testManyInteractionsOnOneElement() {
        IEventTarget eventTarget = new DummyGUIElement("elem1");
        simulateEvent(new DummyInteraction("bla", 1), eventTarget);
        simulateEvent(new DummyInteraction("bli", 1), eventTarget);
        simulateEvent(new DummyInteraction("blo", 1), eventTarget);
        simulateEvent(new DummyInteraction("blu", 1), eventTarget);
        simulateEvent(new DummyInteraction("bla", 1), eventTarget);

        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence {" +
             "  Event bla {}" +
             "  Event bli {}" +
             "  Event blo {}" +
             "  Event blu {}" +
             "  Event bla {}" +
             "}", getTaskTree());
    }

    /**
     *
     */
    @Test
    public void testOneInteractionOnManyElements() {
        IEventTarget eventTarget1 = new DummyGUIElement("elem1");
        IEventTarget eventTarget2 = new DummyGUIElement("elem2");
        IEventTarget eventTarget3 = new DummyGUIElement("elem3");
        IEventTarget eventTarget4 = new DummyGUIElement("elem4");
        IEventTarget eventTarget5 = new DummyGUIElement("elem5");
        IEventTarget eventTarget6 = new DummyGUIElement("elem6");
        simulateEvent(new DummyInteraction("bla", 1), eventTarget1);
        simulateEvent(new DummyInteraction("bli", 1), eventTarget2);
        simulateEvent(new DummyInteraction("bla", 1), eventTarget3);
        simulateEvent(new DummyInteraction("bli", 1), eventTarget4);
        simulateEvent(new DummyInteraction("blo", 1), eventTarget5);
        simulateEvent(new DummyInteraction("bla", 1), eventTarget6);

        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence0 {" +
             "  Sequence sequence1 {" +
             "    Event bla {}" +
             "  }" +
             "  Sequence sequence2 {" +
             "    Event bli {}" +
             "  }" +
             "  Sequence sequence3 {" +
             "    Event bla {}" +
             "  }" +
             "  Sequence sequence4 {" +
             "    Event bli {}" +
             "  }" +
             "  Sequence sequence5 {" +
             "    Event blo {}" +
             "  }" +
             "  Sequence sequence6 {" +
             "    Event bla {}" +
             "  }" +
             "}", getTaskTree());
    }

    /**
     *
     */
    @Test
    public void testManyInteractionsOnManyElements() {
        IEventTarget eventTarget1 = new DummyGUIElement("elem1");
        IEventTarget eventTarget2 = new DummyGUIElement("elem2");
        IEventTarget eventTarget3 = new DummyGUIElement("elem3");
        IEventTarget eventTarget4 = new DummyGUIElement("elem4");
        IEventTarget eventTarget5 = new DummyGUIElement("elem5");
        IEventTarget eventTarget6 = new DummyGUIElement("elem6");
        simulateEvent(new DummyInteraction("bla", 1), eventTarget1);
        simulateEvent(new DummyInteraction("bli", 1), eventTarget1);
        simulateEvent(new DummyInteraction("bla", 1), eventTarget1);
        simulateEvent(new DummyInteraction("bli", 1), eventTarget2);
        simulateEvent(new DummyInteraction("blo", 1), eventTarget2);
        simulateEvent(new DummyInteraction("bla", 1), eventTarget3);
        simulateEvent(new DummyInteraction("bli", 1), eventTarget4);
        simulateEvent(new DummyInteraction("bla", 1), eventTarget4);
        simulateEvent(new DummyInteraction("bli", 1), eventTarget4);
        simulateEvent(new DummyInteraction("blo", 1), eventTarget4);
        simulateEvent(new DummyInteraction("bla", 1), eventTarget5);
        simulateEvent(new DummyInteraction("bli", 1), eventTarget6);
        simulateEvent(new DummyInteraction("bla", 1), eventTarget6);
        simulateEvent(new DummyInteraction("bli", 1), eventTarget6);
        simulateEvent(new DummyInteraction("blo", 1), eventTarget6);

        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence0 {" +
             "  Sequence sequence1 {" +
             "    Event bla {}" +
             "    Event bli {}" +
             "    Event bla {}" +
             "  }" +
             "  Sequence sequence2 {" +
             "    Event bli {}" +
             "    Event blo {}" +
             "  }" +
             "  Sequence sequence3 {" +
             "    Event bla {}" +
             "  }" +
             "  Sequence sequence4 {" +
             "    Event bli {}" +
             "    Event bla {}" +
             "    Event bli {}" +
             "    Event blo {}" +
             "  }" +
             "  Sequence sequence5 {" +
             "    Event bla {}" +
             "  }" +
             "  Sequence sequence6 {" +
             "    Event bli {}" +
             "    Event bla {}" +
             "    Event bli {}" +
             "    Event blo {}" +
             "  }" +
             "}", getTaskTree());
    }

}
