package de.ugoe.cs.quest.ui.swt;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;

import de.ugoe.cs.quest.ui.GlobalDataContainer;
import de.ugoe.cs.util.StringTools;
import de.ugoe.cs.util.console.CommandExecuter;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;

public class DataTabComposite extends Composite {

    List dataList;

    /**
     * Create the composite.
     * 
     * @param parent
     * @param style
     */
    public DataTabComposite(Composite parent, int style) {
        super(parent, style);
        createContent();
    }

    private void createContent() {
        setLayout(new GridLayout(3, false));

        dataList = new List(this, SWT.BORDER | SWT.V_SCROLL);
        dataList.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 3, 1));

        Button btnLoad = new Button(this, SWT.NONE);
        btnLoad.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                GetObjectNameDialog getObjectNameDialog =
                    new GetObjectNameDialog(getShell(), SWT.NONE);
                getObjectNameDialog.open();
                String objectName = getObjectNameDialog.getObjectName();
                if ("".equals(objectName)) {
                    return;
                }
                FileDialog fileDialog = new FileDialog(getShell(), SWT.OPEN);
                String filename = fileDialog.open();
                if (filename == null) {
                    return;
                }
                String command = "loadObject " + filename + " " + objectName;
                CommandExecuter.getInstance().exec(command);
                updateDataList();
            }
        });
        btnLoad.setText("Load");

        Button btnSave = new Button(this, SWT.NONE);
        btnSave.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                String[] selectedStrings = dataList.getSelection();
                if (selectedStrings.length == 0) {
                    SWTHelpers.noSelectionError(getShell());
                    return;
                }
                if (selectedStrings.length > 1) {
                    MessageBox messageBox = new MessageBox(getShell(), SWT.ERROR);
                    messageBox.setText("Error");
                    messageBox.setMessage("Only one object storable at a time." +
                        StringTools.ENDLINE + "Please select only one object.");
                    return;
                }
                FileDialog fileDialog = new FileDialog(getShell(), SWT.SAVE);
                String filename = fileDialog.open();
                if (filename == null) {
                    return;
                }
                String command = "saveObject " + filename + " " + selectedStrings[0];
                CommandExecuter.getInstance().exec(command);
            }
        });
        btnSave.setText("Save");

        Button btnDelete_2 = new Button(this, SWT.NONE);
        btnDelete_2.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                if (SWTHelpers.deleteSelectedFromStorage(dataList)) {
                    updateDataList();
                }
                else {
                    SWTHelpers.noSelectionError(getShell());
                }
            }
        });
        btnDelete_2.setText("Delete");
    }

    @Override
    protected void checkSubclass() {
        // Disable the check that prevents subclassing of SWT components
    }

    public void updateDataList() {
        dataList.removeAll();
        for (String sequencesName : GlobalDataContainer.getInstance().getAllKeys()) {
            dataList.add(sequencesName);
        }
    }

}
