package de.ugoe.cs.quest.usability;

import java.util.Map;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: 16.07.2012$
 * @author 2012, last modified by $Author: pharms$
 */
public class UsabilityDefect {

    /** */
    private UsabilityDefectSeverity severity;

    /** */
    private UsabilityDefectDescription description;

    /** */
    private Map<String, String> descriptionParameters;

    /**
     * TODO: comment
     * 
     * @param medium
     * @param highTextInputRatio
     */
    public UsabilityDefect(UsabilityDefectSeverity severity, UsabilityDefectDescription description)
    {
        this(severity, description, null);
    }

    /**
     * TODO: comment
     * 
     * @param medium
     * @param highTextInputRatio
     */
    public UsabilityDefect(UsabilityDefectSeverity    severity,
                           UsabilityDefectDescription description,
                           Map<String, String>        parameters)
    {
        this.severity = severity;
        this.description = description;
        this.descriptionParameters = parameters;
    }

    /**
     * TODO: comment
     * 
     * @return
     */
    public UsabilityDefectSeverity getSeverity() {
        return severity;
    }

    /**
     * @param severity
     *            the severity to set
     */
    public void setSeverity(UsabilityDefectSeverity severity) {
        this.severity = severity;
    }

    /**
     * @param description
     *            the description to set
     */
    public void setDescription(UsabilityDefectDescription description) {
        this.description = description;
    }

    /**
   * 
   */
    public String getParameterizedDescription() {
        return description.toString(descriptionParameters);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof UsabilityDefect) {
            return
                (severity == ((UsabilityDefect) obj).severity) &&
                (description == ((UsabilityDefect) obj).description);
        }
        else {
            return false;
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        return severity.hashCode() + description.hashCode();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return "UsabilityDefect(" + severity.name() + ", " + description.name() + ")";
    }

}
