
package de.ugoe.cs.quest.ui.commands;

import java.util.List;

import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.CommandExecuter;
import de.ugoe.cs.util.console.Console;

/**
 * <p>
 * Command to list all events (symbols) known to a usage profile (stochastic process).
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDlistCommands implements Command {

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.util.console.Command#run(java.util.List)
     */
    @Override
    public void run(List<Object> parameters) {
        String[] commands = CommandExecuter.getInstance().getAvailableCommands();

        for (String command : commands) {
            Console.println(command);
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.util.console.Command#help()
     */
    @Override
    public void help() {
        Console.println("Usage: listCommands");
    }

}
