package de.ugoe.cs.quest.usability;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.junit.Before;

import de.ugoe.cs.quest.tasktrees.testutils.DummyGUIElement;
import de.ugoe.cs.quest.tasktrees.testutils.DummyInteraction;
import de.ugoe.cs.quest.tasktrees.testutils.DummyTextField;
import de.ugoe.cs.quest.tasktrees.testutils.SimpleLogFormatter;
import de.ugoe.cs.quest.tasktrees.treeifc.IIteration;
import de.ugoe.cs.quest.tasktrees.treeifc.ISelection;
import de.ugoe.cs.quest.tasktrees.treeifc.ISequence;
import de.ugoe.cs.quest.tasktrees.treeifc.ITaskTree;
import de.ugoe.cs.quest.tasktrees.treeifc.ITaskTreeBuilder;
import de.ugoe.cs.quest.tasktrees.treeifc.ITaskTreeNode;
import de.ugoe.cs.quest.tasktrees.treeifc.ITaskTreeNodeFactory;
import de.ugoe.cs.quest.tasktrees.treeifc.ITextInputEventTask;
import de.ugoe.cs.quest.tasktrees.treeimpl.TaskTreeBuilder;
import de.ugoe.cs.quest.tasktrees.treeimpl.TaskTreeNodeFactory;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: 18.07.2012$
 * @author 2012, last modified by $Author: pharms$
 */
public class AbstractUsabilityEvaluationTC {

    /** */
    private ITaskTreeBuilder taskTreeBuilder = new TaskTreeBuilder();

    /** */
    private ITaskTreeNodeFactory taskTreeNodeFactory = new TaskTreeNodeFactory();

    /**
   *
   */
    @Before
    public void setUp() {
        Logger.getLogger("").getHandlers()[0].setFormatter(new SimpleLogFormatter());
    }

    /**
   *
   */
    protected ITaskTree createTaskTree(String spec) {
        Matcher matcher =
            Pattern.compile("(\\s*(\\w+)\\s*(\\(((\\w*\\s*)*)\\))?\\s*(\\{))|(\\})").matcher(spec);

        if (!matcher.find()) {
            if (!matcher.hitEnd()) {
                throw new IllegalArgumentException("could not parse task specification");
            }
        }

        return taskTreeNodeFactory.createTaskTree(parseTask(matcher, new int[1]));
    }

    /**
     * TODO: comment
     * 
     * @param expectedDefects
     * @param evaluateUsability
     */
    protected void assertUsabilityEvaluationResult(UsabilityDefect[]         expectedDefects,
                                                   UsabilityEvaluationResult evaluationResult)
    {
        assertEquals(expectedDefects.length, evaluationResult.getAllDefects().size());

        EXPECTED_DEFECT_ITERATION:
        for (UsabilityDefect expectedDefect : expectedDefects) {
            for (UsabilityDefect defect : evaluationResult.getAllDefects()) {
                if (expectedDefect.equals(defect)) {
                    System.err.println(defect.getParameterizedDescription());
                    continue EXPECTED_DEFECT_ITERATION;
                }
            }

            for (UsabilityDefect defect : evaluationResult.getAllDefects()) {
                System.err.println(defect);
            }

            fail("expected defect " + expectedDefect + " not found in evaluation result");
        }
    }

    /**
   * 
   */
    private ITaskTreeNode parseTask(Matcher tokenMatcher, int[] typeNumbers) {
        String firstToken = tokenMatcher.group();

        if ("}".equals(firstToken)) {
            throw new IllegalArgumentException("found a closing bracket at an unexpected place");
        }

        ITaskTreeNode treeNode = instantiateTreeNode(tokenMatcher, typeNumbers);

        if (!tokenMatcher.find()) {
            throw new IllegalArgumentException("could not parse task specification");
        }

        firstToken = tokenMatcher.group();

        if (!"}".equals(firstToken)) {
            ITaskTreeNode child = null;

            do {
                child = parseTask(tokenMatcher, typeNumbers);

                if (child != null) {
                    addChild(treeNode, child);

                    if (!tokenMatcher.find()) {
                        throw new IllegalArgumentException("could not parse task specification");
                    }

                    firstToken = tokenMatcher.group();

                    if ("}".equals(firstToken)) {
                        break;
                    }
                }

            }
            while (child != null);

        }

        return treeNode;
    }

    /**
     * TODO: comment
     * 
     * @param group
     * @return
     */
    private ITaskTreeNode instantiateTreeNode(Matcher tokenMatcher, int[] typeNumbers) {
        String type = tokenMatcher.group(2);
        String additionalInfo = tokenMatcher.group(4);

        if ("Interaction".equals(type)) {
            return taskTreeNodeFactory.createNewEventTask
                (new DummyInteraction("dummy", typeNumbers[0]++), new DummyGUIElement("dummy"));
        }
        else if ("Sequence".equals(type)) {
            return taskTreeNodeFactory.createNewSequence();
        }
        else if ("Iteration".equals(type)) {
            return taskTreeNodeFactory.createNewIteration();
        }
        else if ("Selection".equals(type)) {
            return taskTreeNodeFactory.createNewSelection();
        }
        else if ("TextInput".equals(type)) {
            if (additionalInfo == null) {
                fail("no simulated text provided for text input interactin task");
            }

            ITextInputEventTask task =
                taskTreeNodeFactory.createNewTextInputEventTask(new DummyTextField(additionalInfo));

            task.setEnteredText(additionalInfo);
            return task;
        }
        else {
            fail("invalid type of task tree node: " + type);
            return null;
        }
    }

    /**
     * TODO: comment
     * 
     * @param treeNode
     * @param child
     */
    private void addChild(ITaskTreeNode parent, ITaskTreeNode child) {
        if (parent instanceof ISequence) {
            taskTreeBuilder.addChild((ISequence) parent, child);
        }
        else if (parent instanceof IIteration) {
            if (parent.getChildren().size() <= 0) {
                taskTreeBuilder.setChild((IIteration) parent, child);
            }
            else {
                fail("can not add more than one child to an iteration");
            }
        }
        else if (parent instanceof ISelection) {
            taskTreeBuilder.addChild((ISelection) parent, child);
        }
        else if (parent instanceof ITextInputEventTask) {
            taskTreeBuilder.addChild((ITextInputEventTask) parent, child);
        }
        else {
            fail("can not add children to parent task tree node of type " +
                 parent.getClass().getName());
        }
    }

}
