package de.ugoe.cs.quest.ui.commands;

import java.security.InvalidParameterException;
import java.util.Collection;
import java.util.List;

import de.ugoe.cs.quest.CommandHelpers;
import de.ugoe.cs.quest.SequenceInstanceOf;
import de.ugoe.cs.quest.coverage.CoverageCalculatorObserved;
import de.ugoe.cs.quest.coverage.CoverageCalculatorProcess;
import de.ugoe.cs.quest.eventcore.Event;
import de.ugoe.cs.quest.ui.GlobalDataContainer;
import de.ugoe.cs.quest.usageprofiles.IStochasticProcess;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

/**
 * <p>
 * Command to calculate the coverage of a test suite.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDcalcCoverage implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void run(List<Object> parameters) {
		String modelname;
		String observedName;
		String[] sequenceNames;
		int minLength;
		int maxLength;
		try {
			modelname = (String) parameters.get(0);
			observedName = (String) parameters.get(1);
			sequenceNames = (String[]) parameters.get(2);
			minLength = Integer.parseInt((String) parameters.get(3));
			maxLength = Integer.parseInt((String) parameters.get(4));
		} catch (Exception e) {
			throw new InvalidParameterException();
		}

		IStochasticProcess process = null;
		Collection<List<Event>> observedSequences = null;
		Collection<List<Event>> sequences = null;
		Object dataObjectProcess = GlobalDataContainer.getInstance().getData(
				modelname);
		Object dataObjectObserved = GlobalDataContainer.getInstance().getData(
				observedName);
		if (dataObjectProcess == null) {
			CommandHelpers.objectNotFoundMessage(modelname);
			return;
		}
		if (!(dataObjectProcess instanceof IStochasticProcess)) {
			CommandHelpers.objectNotType(modelname, "IStochasticProcess");
			return;
		}
		if (dataObjectObserved == null) {
			CommandHelpers.objectNotFoundMessage(observedName);
			return;
		}
		if (!SequenceInstanceOf.isCollectionOfSequences(dataObjectObserved)) {
			CommandHelpers.objectNotType(observedName,
					"Collection<List<Event<?>>>");
			return;
		}
		process = (IStochasticProcess) dataObjectProcess;
		observedSequences = (Collection<List<Event>>) dataObjectObserved;

		Console.print("seqName");
		for (int length = minLength; length <= maxLength; length++) {
			Console.print(";numObs_" + length);
			Console.print(";numCov_" + length);
			Console.print(";numNew_" + length);
			Console.print(";numPos_" + length);
			Console.print(";all_" + length);
			Console.print(";pos_" + length);
			Console.print(";poswei_" + length);
			Console.print(";obs_" + length);
			Console.print(";obswei_" + length);
			Console.print(";new_" + length);
			Console.print(";newpos_" + length);
			Console.print(";newposwei_" + length);
		}
		Console.println("");
		for (String sequenceName : sequenceNames) {
			Object dataObjectSequences = GlobalDataContainer.getInstance()
					.getData(sequenceName);
			if (dataObjectSequences == null) {
				CommandHelpers.objectNotFoundMessage(sequenceName);
				return;
			} else if (!SequenceInstanceOf
					.isCollectionOfSequences(dataObjectSequences)) {
				CommandHelpers.objectNotType(sequenceName,
						"Collection<List<Event<?>>>");
				return;
			}
			sequences = (Collection<List<Event>>) dataObjectSequences;
			Console.print(sequenceName);
			for (int length = minLength; length <= maxLength; length++) {
				CoverageCalculatorProcess covCalcProc = new CoverageCalculatorProcess(
						process, sequences, length);
				CoverageCalculatorObserved covCalcObs = new CoverageCalculatorObserved(
						observedSequences, sequences, length);
				Console.print(";" + covCalcObs.getNumObserved());
				Console.print(";" + covCalcObs.getNumCovered());
				Console.print(";" + covCalcObs.getNumNew());
				Console.print(";" + covCalcProc.getNumPossible());
				Console.print(";" + covCalcProc.getCoverageAllNoWeight());
				Console.print(";" + covCalcProc.getCoveragePossibleNoWeight());
				Console.print(";" + covCalcProc.getCoveragePossibleWeight());
				Console.print(";" + covCalcObs.getCoverageObserved());
				Console.print(";"
						+ covCalcObs.getCoverageObservedWeigth(process));
				Console.print(";" + covCalcObs.getNewPercentage());
				Console.print(";" + covCalcObs.getCoveragePossibleNew(process));
				Console.print(";"
						+ covCalcObs.getCoveragePossibleNewWeight(process));
			}
			Console.println("");
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public String help() {
		return "calcCoverage <modelname> <observedSequences> [sequenceNames] <minCovLength> <maxCovLength>";
	}

}
