package de.ugoe.cs.quest.ui.commands;

import java.security.InvalidParameterException;
import java.util.List;

import de.ugoe.cs.quest.CommandHelpers;
import de.ugoe.cs.quest.ui.GlobalDataContainer;
import de.ugoe.cs.quest.usageprofiles.Trie;
import de.ugoe.cs.quest.usageprofiles.TrieBasedModel;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

/**
 * <p>
 * Command that prints the {@link Trie} of a {@link TrieBasedModel} as dot to
 * the console.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDprintTrieDot implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public String help() {
		return "printTreeDot <modelname>";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@Override
	public void run(List<Object> parameters) {
		String modelname = "";
		try {
			modelname = (String) parameters.get(0);
		} catch (Exception e) {
			throw new InvalidParameterException();
		}

		TrieBasedModel model = null;
		Object dataObject = GlobalDataContainer.getInstance()
				.getData(modelname);
		if (dataObject == null) {
			CommandHelpers.objectNotFoundMessage(modelname);
			return;
		}
		if (!(dataObject instanceof TrieBasedModel)) {
			CommandHelpers.objectNotType(modelname, "TrieBasedModel");
			return;
		}

		model = (TrieBasedModel) dataObject;
		Console.println(model.getTrieDotRepresentation());
	}

}
