package de.ugoe.cs.quest.plugin.jfc.commands;

import java.security.InvalidParameterException;
import java.util.Collection;
import java.util.List;

import de.ugoe.cs.quest.CommandHelpers;
import de.ugoe.cs.quest.eventcore.Event;
import de.ugoe.cs.quest.plugin.jfc.JFCLogParser;
import de.ugoe.cs.quest.ui.GlobalDataContainer;
import de.ugoe.cs.util.console.Command;

/**
 * <p>
 * Command to parse an XML file with sessions monitored by EventBench's
 * JFCMonitor.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDparseJFC implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@Override
	public void run(List<Object> parameters) {
		String filename;
		String sequencesName = "sequences";

		try {
			filename = (String) parameters.get(0);
			if (parameters.size() >= 2) {
				sequencesName = (String) parameters.get(1);
			}
		} catch (Exception e) {
			throw new InvalidParameterException();
		}
		
		JFCLogParser parser = new JFCLogParser();

		parser.parseFile(filename);
		Collection<List<Event>> sequences = parser.getSequences();

		if (GlobalDataContainer.getInstance().addData(sequencesName, sequences)) {
			CommandHelpers.dataOverwritten(sequencesName);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public String help() {
		return "parseJFC <filename> {<sequencesName>}";
	}

}
