/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.guitar.model.wrapper;

import edu.umd.cs.guitar.model.data.ObjectFactory;
import edu.umd.cs.guitar.model.data.StepType;
import edu.umd.cs.guitar.model.data.TestCase;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"guiStructure", "step"})
@XmlRootElement(name="TestCase")
public class TestCaseWrapper
extends TestCase {
    ObjectFactory factory = new ObjectFactory();

    public TestCaseWrapper(TestCase testcase) {
        this.guiStructure = testcase.getGUIStructure();
        this.step = testcase.getStep();
    }

    public TestCase subSteps(int startIndex, int endIndex) {
        TestCase testcase = this.factory.createTestCase();
        for (int i = startIndex; i < endIndex; ++i) {
            StepType step = (StepType)this.step.get(i);
            testcase.getStep().add(i - startIndex, step);
        }
        return testcase;
    }

    public List<String> subSequence(int startIndex, int endIndex) {
        ArrayList<String> sequence = new ArrayList<String>();
        for (int i = startIndex; i < endIndex; ++i) {
            StepType step = (StepType)this.step.get(i);
            if (step == null) continue;
            sequence.add(i - startIndex, step.getEventId());
        }
        return sequence;
    }

    public int size() {
        return this.step.size();
    }
}

