/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.BadTransformException;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.CachedTargets;
import javax.media.j3d.CompileState;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.HashKey;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.LinkRetained;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.SharedGroupRetained;
import javax.media.j3d.SwitchState;
import javax.media.j3d.Targets;
import javax.media.j3d.TargetsInterface;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroupData;
import javax.media.j3d.UpdateTargets;
import javax.media.j3d.VirtualUniverse;
import javax.media.j3d.WakeupIndexedList;
import javax.media.j3d.WakeupOnTransformChange;

class TransformGroupRetained
extends GroupRetained
implements TargetsInterface {
    Transform3D transform = new Transform3D();
    Transform3D invTransform = null;
    Transform3D normalTransform = null;
    Transform3D currentTransform = new Transform3D();
    Transform3D[][] childLocalToVworld = null;
    int[][] childLocalToVworldIndex = null;
    Transform3D[][] childTrans = null;
    int[][] childTransIndex = null;
    int localTargetThreads = 0;
    int targetThreads = 0;
    WakeupIndexedList transformChange = null;
    ArrayList childTransformLinks = new ArrayList(1);
    boolean needNormalsTransform = false;
    HashKey currentKey = new HashKey();
    boolean aboveAViewPlatform = false;
    int maxTransformLevel = -1;
    int[] transformLevels = null;
    CachedTargets[] j3dCTs = null;
    CachedTargets[] cachedTargets = null;
    TransformGroupData[] perPathData = null;

    TransformGroupRetained() {
        this.nodeType = 24;
    }

    void setTransform(Transform3D transform3D) {
        J3dMessage j3dMessage = null;
        Transform3D transform3D2 = null;
        if (this.staticTransform != null) {
            transform3D2 = VirtualUniverse.mc.getTransform3D(this.staticTransform.transform);
            transform3D2.mul(transform3D);
            this.transform.setWithLock(transform3D2);
        } else {
            transform3D2 = VirtualUniverse.mc.getTransform3D(transform3D);
            this.transform.setWithLock(transform3D);
        }
        if (this.transformChange != null) {
            this.notifyConditions();
        }
        if (this.source.isLive()) {
            if (this.aboveAViewPlatform && !transform3D.isCongruent()) {
                throw new BadTransformException(J3dI18N.getString("ViewPlatformRetained0"));
            }
            j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.type = 3;
            j3dMessage.threads = this.targetThreads;
            j3dMessage.args[1] = this;
            j3dMessage.args[2] = transform3D2;
            j3dMessage.universe = this.universe;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    void getTransform(Transform3D transform3D) {
        this.transform.getWithLock(transform3D);
        if (this.staticTransform != null) {
            Transform3D transform3D2 = this.staticTransform.getInvTransform();
            transform3D.mul(transform3D2, transform3D);
        }
    }

    Transform3D getInvTransform() {
        if (this.invTransform == null) {
            this.invTransform = new Transform3D(this.transform);
            this.invTransform.invert();
        }
        return this.invTransform;
    }

    Transform3D getNormalTransform() {
        if (this.normalTransform == null) {
            this.normalTransform = new Transform3D(this.transform);
            this.normalTransform.invert();
            this.normalTransform.transpose();
        }
        return this.normalTransform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void setNodeData(SetLiveState setLiveState) {
        super.setNodeData(setLiveState);
        this.childTrans = new Transform3D[setLiveState.currentTransforms.length][2];
        this.childTransIndex = new int[setLiveState.currentTransforms.length][2];
        int n = 0;
        while (n < setLiveState.currentTransforms.length) {
            this.childTrans[n][0] = new Transform3D();
            this.childTrans[n][0].mul(setLiveState.currentTransforms[n][setLiveState.currentTransformsIndex[n][1]], this.currentTransform);
            this.childTrans[n][1] = new Transform3D(this.childTrans[n][0]);
            this.childTransIndex[n][0] = 0;
            this.childTransIndex[n][1] = 0;
            ++n;
        }
        if (!setLiveState.inSharedGroup) {
            setLiveState.transformLevels[0] = setLiveState.transformLevels[0] + 1;
            this.maxTransformLevel = setLiveState.transformLevels[0];
        } else {
            n = 0;
            while (n < setLiveState.keys.length) {
                int n2 = n;
                setLiveState.transformLevels[n2] = setLiveState.transformLevels[n2] + 1;
                if (setLiveState.transformLevels[n] > this.maxTransformLevel) {
                    this.maxTransformLevel = setLiveState.transformLevels[n];
                }
                ++n;
            }
        }
        if (!this.inSharedGroup) {
            if (this.childLocalToVworld == null) {
                this.childLocalToVworld = new Transform3D[1][];
                this.childLocalToVworldIndex = new int[1][];
                this.transformLevels = new int[1];
                this.cachedTargets = new CachedTargets[1];
                this.perPathData = new TransformGroupData[1];
            }
            this.childLocalToVworld[0] = this.childTrans[0];
            this.childLocalToVworldIndex[0] = this.childTransIndex[0];
            this.transformLevels[0] = setLiveState.transformLevels[0];
            this.setAuxData(setLiveState, 0, 0);
        } else {
            int n3;
            int n4;
            if (this.childLocalToVworld == null) {
                this.childLocalToVworld = new Transform3D[setLiveState.keys.length][];
                this.childLocalToVworldIndex = new int[setLiveState.keys.length][];
                this.transformLevels = new int[setLiveState.keys.length];
                this.cachedTargets = new CachedTargets[setLiveState.keys.length];
                this.perPathData = new TransformGroupData[setLiveState.keys.length];
                n4 = 0;
            } else {
                n4 = this.localToVworld.length - setLiveState.keys.length;
                n3 = this.localToVworld.length;
                Transform3D[][] transform3DArrayArray = new Transform3D[n3][];
                int[][] nArrayArray = new int[n3][];
                int[] nArray = new int[n3];
                CachedTargets[] cachedTargetsArray = new CachedTargets[n3];
                TransformGroupData[] transformGroupDataArray = new TransformGroupData[n3];
                System.arraycopy(this.childLocalToVworld, 0, transform3DArrayArray, 0, this.childLocalToVworld.length);
                System.arraycopy(this.childLocalToVworldIndex, 0, nArrayArray, 0, this.childLocalToVworldIndex.length);
                System.arraycopy(this.transformLevels, 0, nArray, 0, this.transformLevels.length);
                System.arraycopy(this.cachedTargets, 0, cachedTargetsArray, 0, this.cachedTargets.length);
                System.arraycopy(this.perPathData, 0, transformGroupDataArray, 0, this.perPathData.length);
                this.childLocalToVworld = transform3DArrayArray;
                this.childLocalToVworldIndex = nArrayArray;
                this.transformLevels = nArray;
                this.cachedTargets = cachedTargetsArray;
                this.perPathData = transformGroupDataArray;
            }
            n = n4;
            int n5 = 0;
            while (n < this.localToVworld.length) {
                n3 = setLiveState.keys[n5].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                if (n3 < 0) {
                    System.out.println("Can't Find matching hashKey in setNodeData.");
                    System.out.println("We're in TROUBLE!!!");
                    break;
                }
                if (n3 >= n) {
                    this.childLocalToVworld[n] = this.childTrans[n5];
                    this.childLocalToVworldIndex[n] = this.childTransIndex[n5];
                    this.transformLevels[n] = setLiveState.transformLevels[n5];
                } else {
                    int n6 = n3 + 1;
                    int n7 = n - n3;
                    System.arraycopy(this.childLocalToVworld, n3, this.childLocalToVworld, n6, n7);
                    System.arraycopy(this.childLocalToVworldIndex, n3, this.childLocalToVworldIndex, n6, n7);
                    System.arraycopy(this.transformLevels, n3, this.transformLevels, n6, n7);
                    System.arraycopy(this.cachedTargets, n3, this.cachedTargets, n6, n7);
                    System.arraycopy(this.perPathData, n3, this.perPathData, n6, n7);
                    this.childLocalToVworld[n3] = this.childTrans[n5];
                    this.childLocalToVworldIndex[n3] = this.childTransIndex[n5];
                    this.transformLevels[n3] = setLiveState.transformLevels[n5];
                }
                this.setAuxData(setLiveState, n5, n3);
                ++n;
                ++n5;
            }
        }
        if (setLiveState.childTransformLinks != null) {
            ArrayList arrayList = setLiveState.childTransformLinks;
            synchronized (arrayList) {
                if (!this.inSharedGroup || !setLiveState.childTransformLinks.contains(this)) {
                    setLiveState.childTransformLinks.add(this);
                }
            }
        }
        setLiveState.localToVworld = this.childLocalToVworld;
        setLiveState.localToVworldIndex = this.childLocalToVworldIndex;
        setLiveState.currentTransforms = this.childTrans;
        setLiveState.currentTransformsIndex = this.childTransIndex;
        setLiveState.childTransformLinks = this.childTransformLinks;
        setLiveState.parentTransformLink = this;
    }

    void setAuxData(SetLiveState setLiveState, int n, int n2) {
        super.setAuxData(setLiveState, n, n2);
        this.perPathData[n2] = new TransformGroupData();
        this.perPathData[n2].switchState = (SwitchState)setLiveState.switchStates.get(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCondition(WakeupOnTransformChange wakeupOnTransformChange) {
        WakeupIndexedList wakeupIndexedList = this.transformChange;
        synchronized (wakeupIndexedList) {
            this.transformChange.remove(wakeupOnTransformChange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addCondition(WakeupOnTransformChange wakeupOnTransformChange) {
        WakeupIndexedList wakeupIndexedList = this.transformChange;
        synchronized (wakeupIndexedList) {
            this.transformChange.add(wakeupOnTransformChange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyConditions() {
        WakeupIndexedList wakeupIndexedList = this.transformChange;
        synchronized (wakeupIndexedList) {
            WakeupOnTransformChange[] wakeupOnTransformChangeArray = (WakeupOnTransformChange[])this.transformChange.toArray(false);
            int n = this.transformChange.size() - 1;
            while (n >= 0) {
                wakeupOnTransformChangeArray[n].setTriggered();
                --n;
            }
        }
    }

    boolean isStatic() {
        return super.isStatic() && !this.source.getCapability(17) && !this.source.getCapability(18);
    }

    void mergeTransform(TransformGroupRetained transformGroupRetained) {
        super.mergeTransform(transformGroupRetained);
        this.transform.mul(transformGroupRetained.transform, this.transform);
    }

    void traverse(boolean bl, int n) {
        System.out.println();
        int n2 = 0;
        while (n2 < n) {
            System.out.print(".");
            ++n2;
        }
        System.out.print(this);
        if (this.isStatic()) {
            System.out.print(" (s)");
        } else {
            System.out.print(" (w)");
        }
        System.out.println();
        System.out.println(this.transform.toString());
        super.traverse(true, n);
    }

    void compile(CompileState compileState) {
        boolean bl = compileState.keepTG;
        compileState.keepTG = false;
        boolean bl2 = compileState.needNormalsTransform;
        compileState.needNormalsTransform = false;
        super.compile(compileState);
        if (compileState.keepTG) {
            this.mergeFlag = 0;
        }
        if (this.mergeFlag == 0) {
            compileState.staticTransform = null;
            compileState.parentGroup = null;
            super.merge(compileState);
        } else {
            this.mergeFlag = 1;
        }
        compileState.keepTG = bl;
        this.needNormalsTransform = compileState.needNormalsTransform;
        compileState.needNormalsTransform = bl2;
    }

    void merge(CompileState compileState) {
        Transform3D transform3D;
        if (compileState.staticTransform != null) {
            this.staticTransform = compileState.staticTransform;
            this.mergeTransform(compileState.staticTransform);
        }
        if (this.mergeFlag == 1 && this.needNormalsTransform && !(transform3D = this.getNormalTransform()).isCongruent()) {
            this.mergeFlag = 0;
        }
        if (this.mergeFlag == 1) {
            TransformGroupRetained transformGroupRetained = compileState.staticTransform;
            compileState.staticTransform = this;
            super.merge(compileState);
            compileState.staticTransform = transformGroupRetained;
        } else {
            compileState.parentGroup.compiledChildrenList.add(this);
            this.parent = compileState.parentGroup;
        }
        this.mergeFlag = 2;
    }

    void setLive(SetLiveState setLiveState) {
        Transform3D transform3D = null;
        Targets[] targetsArray = null;
        Targets[] targetsArray2 = null;
        int n = 0;
        n = setLiveState.traverseFlags;
        targetsArray2 = setLiveState.transformTargets;
        int n2 = setLiveState.inSharedGroup ? setLiveState.keys.length : 1;
        targetsArray = new Targets[n2];
        int n3 = 0;
        while (n3 < n2) {
            targetsArray[n3] = new Targets();
            ++n3;
        }
        setLiveState.transformTargets = targetsArray;
        setLiveState.traverseFlags = 0;
        this.inSharedGroup = setLiveState.inSharedGroup;
        transform3D = VirtualUniverse.mc.getTransform3D(null);
        this.transform.getWithLock(transform3D);
        this.currentTransform.set(transform3D);
        ArrayList arrayList = setLiveState.childTransformLinks;
        GroupRetained groupRetained = setLiveState.parentTransformLink;
        Transform3D[][] transform3DArray = setLiveState.currentTransforms;
        int[][] nArray = setLiveState.currentTransformsIndex;
        super.doSetLive(setLiveState);
        if (!this.inSharedGroup) {
            if (setLiveState.transformTargets[0] != null) {
                this.cachedTargets[0] = setLiveState.transformTargets[0].snapShotInit();
            }
            if (setLiveState.switchTargets != null && setLiveState.switchTargets[0] != null) {
                setLiveState.switchTargets[0].addNode(this, 6);
            }
        } else {
            n3 = 0;
            while (n3 < n2) {
                if (setLiveState.transformTargets[n3] != null) {
                    int n4 = setLiveState.keys[n3].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                    this.cachedTargets[n4] = setLiveState.transformTargets[n3].snapShotInit();
                }
                if (setLiveState.switchTargets != null && setLiveState.switchTargets[n3] != null) {
                    setLiveState.switchTargets[n3].addNode(this, 6);
                }
                ++n3;
            }
        }
        this.j3dCTs = new CachedTargets[this.cachedTargets.length];
        this.copyCachedTargets(0, this.j3dCTs);
        this.computeTargetThreads(0, this.cachedTargets);
        setLiveState.localToVworld = this.localToVworld;
        setLiveState.localToVworldIndex = this.localToVworldIndex;
        setLiveState.currentTransforms = transform3DArray;
        setLiveState.currentTransformsIndex = nArray;
        setLiveState.childTransformLinks = arrayList;
        setLiveState.parentTransformLink = groupRetained;
        setLiveState.transformTargets = targetsArray2;
        if (!setLiveState.inSharedGroup) {
            setLiveState.transformLevels[0] = setLiveState.transformLevels[0] - 1;
        } else {
            n3 = 0;
            while (n3 < setLiveState.keys.length) {
                int n5 = n3++;
                setLiveState.transformLevels[n5] = setLiveState.transformLevels[n5] - 1;
            }
        }
        if ((setLiveState.traverseFlags & 1) != 0) {
            this.aboveAViewPlatform = true;
        }
        setLiveState.traverseFlags |= n;
        if (this.aboveAViewPlatform && !transform3D.isCongruent()) {
            throw new BadTransformException(J3dI18N.getString("ViewPlatformRetained0"));
        }
        super.markAsLive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeNodeData(SetLiveState setLiveState) {
        TransformGroupRetained transformGroupRetained = this;
        synchronized (transformGroupRetained) {
            if (this.refCount <= 0) {
                this.childLocalToVworld = null;
                this.childLocalToVworldIndex = null;
                this.transformLevels = null;
                this.cachedTargets = null;
                this.perPathData = null;
                this.targetThreads = 0;
                if (this.parentTransformLink != null) {
                    ArrayList arrayList = this.parentTransformLink instanceof TransformGroupRetained ? ((TransformGroupRetained)this.parentTransformLink).childTransformLinks : ((SharedGroupRetained)this.parentTransformLink).childTransformLinks;
                    ArrayList arrayList2 = arrayList;
                    synchronized (arrayList2) {
                        arrayList.remove(this);
                    }
                }
                this.aboveAViewPlatform = false;
            } else {
                int n;
                int n2 = this.localToVworld.length - setLiveState.keys.length;
                Transform3D[][] transform3DArrayArray = new Transform3D[n2][];
                int[][] nArrayArray = new int[n2][];
                int[] nArray = new int[n2];
                ArrayList[] arrayListArray = new ArrayList[n2];
                CachedTargets[] cachedTargetsArray = new CachedTargets[n2];
                TransformGroupData[] transformGroupDataArray = new TransformGroupData[n2];
                int[] nArray2 = new int[setLiveState.keys.length];
                int n3 = 0;
                int n4 = 0;
                boolean bl = false;
                int n5 = 0;
                while (n5 < setLiveState.keys.length) {
                    int n6;
                    nArray2[n5] = n6 = setLiveState.keys[n5].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                    if (n6 >= 0) {
                        bl = true;
                        if (n6 == n3) {
                            ++n3;
                        } else {
                            n = n6 - n3;
                            System.arraycopy(this.childLocalToVworld, n3, transform3DArrayArray, n4, n);
                            System.arraycopy(this.childLocalToVworldIndex, n3, nArrayArray, n4, n);
                            System.arraycopy(this.transformLevels, n3, nArray, n4, n);
                            System.arraycopy(this.cachedTargets, n3, cachedTargetsArray, n4, n);
                            System.arraycopy(this.perPathData, n3, transformGroupDataArray, n4, n);
                            n3 = n6 + 1;
                            n4 += n;
                        }
                    } else {
                        bl = false;
                        System.out.println("TG.removeNodeData-Can't find matching hashKey.");
                        System.out.println("We're in TROUBLE!!!");
                    }
                    ++n5;
                }
                if (bl && n3 < this.localToVworld.length) {
                    n = this.localToVworld.length - n3;
                    System.arraycopy(this.childLocalToVworld, n3, transform3DArrayArray, n4, n);
                    System.arraycopy(this.childLocalToVworldIndex, n3, nArrayArray, n4, n);
                    System.arraycopy(this.transformLevels, n3, nArray, n4, n);
                    System.arraycopy(this.cachedTargets, n3, cachedTargetsArray, n4, n);
                    System.arraycopy(this.perPathData, n3, transformGroupDataArray, n4, n);
                }
                this.childLocalToVworld = transform3DArrayArray;
                this.childLocalToVworldIndex = nArrayArray;
                this.transformLevels = nArray;
                this.cachedTargets = cachedTargetsArray;
                this.perPathData = transformGroupDataArray;
            }
            super.removeNodeData(setLiveState);
            setLiveState.localToVworld = this.childLocalToVworld;
            setLiveState.localToVworldIndex = this.childLocalToVworldIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearLive(SetLiveState setLiveState) {
        Targets[] targetsArray = null;
        targetsArray = setLiveState.transformTargets;
        setLiveState.transformTargets = null;
        super.clearLive(setLiveState);
        setLiveState.localToVworld = this.localToVworld;
        setLiveState.localToVworldIndex = this.localToVworldIndex;
        setLiveState.transformTargets = targetsArray;
        TransformGroupRetained transformGroupRetained = this;
        synchronized (transformGroupRetained) {
            if (this.inSharedGroup) {
                int n;
                if (this.transformLevels != null) {
                    this.maxTransformLevel = this.transformLevels[0];
                    n = 1;
                    while (n < this.transformLevels.length) {
                        if (this.transformLevels[n] > this.maxTransformLevel) {
                            this.maxTransformLevel = this.transformLevels[n];
                        }
                        ++n;
                    }
                } else {
                    this.maxTransformLevel = -1;
                }
                if (setLiveState.switchTargets != null) {
                    n = 0;
                    while (n < setLiveState.switchTargets.length) {
                        if (setLiveState.switchTargets[n] != null) {
                            setLiveState.switchTargets[n].addNode(this, 6);
                        }
                        ++n;
                    }
                }
            } else {
                this.maxTransformLevel = -1;
                if (setLiveState.switchTargets != null && setLiveState.switchTargets[0] != null) {
                    setLiveState.switchTargets[0].addNode(this, 6);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeCombineBounds(Bounds bounds) {
        BoundingSphere boundingSphere = new BoundingSphere();
        boundingSphere.setRadius(-1.0);
        if (this.boundsAutoCompute) {
            int n = this.children.size() - 1;
            while (n >= 0) {
                NodeRetained nodeRetained = (NodeRetained)this.children.get(n);
                if (nodeRetained != null) {
                    nodeRetained.computeCombineBounds(boundingSphere);
                }
                --n;
            }
        } else {
            Bounds bounds2 = this.localBounds;
            synchronized (bounds2) {
                boundingSphere.set(this.localBounds);
            }
        }
        Transform3D transform3D = this.transform;
        synchronized (transform3D) {
            boundingSphere.transform(this.transform);
        }
        bounds.combine(boundingSphere);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processChildLocalToVworld(ArrayList arrayList, ArrayList arrayList2, UpdateTargets updateTargets, ArrayList arrayList3) {
        TransformGroupRetained transformGroupRetained = this;
        synchronized (transformGroupRetained) {
            if (this.inSharedGroup) {
                if (this.localToVworldKeys != null) {
                    int n = 0;
                    while (n < this.localToVworldKeys.length) {
                        if (this.perPathData[n].markedDirty) {
                            this.updateChildLocalToVworld(this.localToVworldKeys[n], n, arrayList, arrayList2, updateTargets, arrayList3);
                        }
                        ++n;
                    }
                }
            } else if (this.perPathData != null && this.perPathData[0].markedDirty) {
                this.updateChildLocalToVworld(arrayList, arrayList2, updateTargets, arrayList3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateChildLocalToVworld(HashKey hashKey, int n, ArrayList arrayList, ArrayList arrayList2, UpdateTargets updateTargets, ArrayList arrayList3) {
        TransformGroupRetained transformGroupRetained = this;
        synchronized (transformGroupRetained) {
            if (this.localToVworld != null) {
                this.perPathData[n].markedDirty = false;
                if (this.perPathData[n].switchState.currentSwitchOn) {
                    Transform3D transform3D = this.getCurrentLocalToVworld(n);
                    Transform3D transform3D2 = this.getUpdateChildLocalToVworld(n);
                    transform3D2.mul(transform3D, this.currentTransform);
                    arrayList.add(this);
                    arrayList2.add(hashKey);
                    CachedTargets cachedTargets = this.j3dCTs[n];
                    if (cachedTargets != null) {
                        updateTargets.addCachedTargets(cachedTargets);
                        if (cachedTargets.targetArr[5] != null) {
                            GroupRetained.gatherBlUsers(arrayList3, cachedTargets.targetArr[5]);
                        }
                    }
                } else {
                    this.perPathData[n].switchDirty = true;
                }
                ArrayList arrayList4 = this.childTransformLinks;
                synchronized (arrayList4) {
                    int n2 = 0;
                    while (n2 < this.childTransformLinks.size()) {
                        Object e = this.childTransformLinks.get(n2);
                        if (e instanceof TransformGroupRetained) {
                            TransformGroupRetained transformGroupRetained2 = (TransformGroupRetained)e;
                            transformGroupRetained2.updateChildLocalToVworld(transformGroupRetained2.localToVworldKeys[n], n, arrayList, arrayList2, updateTargets, arrayList3);
                        } else {
                            LinkRetained linkRetained = (LinkRetained)e;
                            this.currentKey.set(this.localToVworldKeys[n]);
                            this.currentKey.append(LinkRetained.plus).append(linkRetained.nodeId);
                            if (linkRetained.sharedGroup != null && linkRetained.sharedGroup.localToVworldKeys != null) {
                                int n3 = this.currentKey.equals(linkRetained.sharedGroup.localToVworldKeys, 0, linkRetained.sharedGroup.localToVworldKeys.length);
                                if (n3 < 0) {
                                    System.out.println("TransformGroupRetained : Can't find hashKey");
                                }
                                if (n3 < linkRetained.sharedGroup.localToVworldKeys.length) {
                                    linkRetained.sharedGroup.updateChildLocalToVworld(linkRetained.sharedGroup.localToVworldKeys[n3], n3, arrayList, arrayList2, updateTargets, arrayList3);
                                }
                            }
                        }
                        ++n2;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateChildLocalToVworld(ArrayList arrayList, ArrayList arrayList2, UpdateTargets updateTargets, ArrayList arrayList3) {
        TransformGroupRetained transformGroupRetained = this;
        synchronized (transformGroupRetained) {
            if (this.localToVworld != null) {
                this.perPathData[0].markedDirty = false;
                if (this.perPathData[0].switchState.currentSwitchOn) {
                    Transform3D transform3D = this.getCurrentLocalToVworld(0);
                    Transform3D transform3D2 = this.getUpdateChildLocalToVworld(0);
                    transform3D2.mul(transform3D, this.currentTransform);
                    arrayList.add(this);
                    CachedTargets cachedTargets = this.j3dCTs[0];
                    if (cachedTargets != null) {
                        updateTargets.addCachedTargets(cachedTargets);
                        if (cachedTargets.targetArr[5] != null) {
                            GroupRetained.gatherBlUsers(arrayList3, cachedTargets.targetArr[5]);
                        }
                    }
                } else {
                    this.perPathData[0].switchDirty = true;
                }
                ArrayList arrayList4 = this.childTransformLinks;
                synchronized (arrayList4) {
                    int n = 0;
                    while (n < this.childTransformLinks.size()) {
                        Object e = this.childTransformLinks.get(n);
                        if (e instanceof TransformGroupRetained) {
                            TransformGroupRetained transformGroupRetained2 = (TransformGroupRetained)e;
                            transformGroupRetained2.updateChildLocalToVworld(arrayList, arrayList2, updateTargets, arrayList3);
                        } else {
                            LinkRetained linkRetained = (LinkRetained)e;
                            this.currentKey.reset();
                            this.currentKey.append(this.locale.nodeId);
                            this.currentKey.append(LinkRetained.plus).append(linkRetained.nodeId);
                            if (linkRetained.sharedGroup != null && linkRetained.sharedGroup.localToVworldKeys != null) {
                                int n2 = this.currentKey.equals(linkRetained.sharedGroup.localToVworldKeys, 0, linkRetained.sharedGroup.localToVworldKeys.length);
                                if (n2 < 0) {
                                    System.out.println("TransformGroupRetained : Can't find hashKey");
                                }
                                if (n2 < linkRetained.sharedGroup.localToVworldKeys.length) {
                                    linkRetained.sharedGroup.updateChildLocalToVworld(linkRetained.sharedGroup.localToVworldKeys[n2], n2, arrayList, arrayList2, updateTargets, arrayList3);
                                }
                            }
                        }
                        ++n;
                    }
                }
            }
        }
    }

    void transformBounds(SceneGraphPath sceneGraphPath, Bounds bounds) {
        if (!((NodeRetained)sceneGraphPath.item.retained).inSharedGroup) {
            bounds.transform(this.getCurrentChildLocalToVworld());
        } else {
            HashKey hashKey = new HashKey("");
            sceneGraphPath.getHashKey(hashKey);
            bounds.transform(this.getCurrentChildLocalToVworld(hashKey));
        }
    }

    Transform3D getUpdateChildLocalToVworld(int n) {
        int n2 = this.childLocalToVworldIndex[n][1];
        if (n2 == this.childLocalToVworldIndex[n][0]) {
            this.childLocalToVworldIndex[n][1] = n2 ^= 1;
        }
        return this.childLocalToVworld[n][n2];
    }

    Transform3D getCurrentChildLocalToVworld() {
        return this.getCurrentChildLocalToVworld(0);
    }

    Transform3D getCurrentChildLocalToVworld(int n) {
        return this.childLocalToVworld[n][this.childLocalToVworldIndex[n][1]];
    }

    Transform3D getCurrentChildLocalToVworld(HashKey hashKey) {
        if (!this.inSharedGroup) {
            return this.childLocalToVworld[0][this.childLocalToVworldIndex[0][1]];
        }
        int n = hashKey.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
        if (n >= 0) {
            return this.childLocalToVworld[n][this.childLocalToVworldIndex[n][1]];
        }
        return new Transform3D();
    }

    Transform3D getLastChildLocalToVworld(HashKey hashKey) {
        if (!this.inSharedGroup) {
            return this.childLocalToVworld[0][this.childLocalToVworldIndex[0][0]];
        }
        int n = hashKey.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
        if (n >= 0) {
            return this.childLocalToVworld[n][this.childLocalToVworldIndex[n][0]];
        }
        return new Transform3D();
    }

    public int getTargetThreads(int n) {
        if (n == 0) {
            return this.targetThreads;
        }
        System.out.println("getTargetsThreads: wrong arguments");
        return -1;
    }

    public CachedTargets getCachedTargets(int n, int n2, int n3) {
        if (n == 0) {
            return this.cachedTargets[n2];
        }
        System.out.println("getCachedTargets: wrong arguments");
        return null;
    }

    TargetsInterface getClosestTargetsInterface(int n) {
        return n == 0 ? this : (TargetsInterface)((Object)this.parentSwitchLink);
    }

    public void computeTargetThreads(int n, CachedTargets[] cachedTargetsArray) {
        if (n == 0) {
            this.localTargetThreads = 8192;
            int n2 = 0;
            while (n2 < cachedTargetsArray.length) {
                if (cachedTargetsArray[n2] != null) {
                    this.localTargetThreads |= cachedTargetsArray[n2].computeTargetThreads();
                }
                ++n2;
            }
            this.targetThreads = this.localTargetThreads;
            int n3 = this.childTransformLinks.size();
            int n4 = 0;
            while (n4 < n3) {
                NodeRetained nodeRetained = (NodeRetained)this.childTransformLinks.get(n4);
                TargetsInterface targetsInterface = nodeRetained.nodeType == 9 ? ((LinkRetained)nodeRetained).sharedGroup : (TargetsInterface)((Object)nodeRetained);
                if (targetsInterface != null) {
                    this.targetThreads |= targetsInterface.getTargetThreads(0);
                }
                ++n4;
            }
        } else {
            System.out.println("computeTargetsThreads: wrong arguments");
        }
    }

    public void updateTargetThreads(int n, CachedTargets[] cachedTargetsArray) {
        if (n == 0) {
            this.computeTargetThreads(n, cachedTargetsArray);
            if (this.parentTransformLink != null) {
                TargetsInterface targetsInterface = (TargetsInterface)((Object)this.parentTransformLink);
                targetsInterface.propagateTargetThreads(0, this.targetThreads);
            }
        } else {
            System.out.println("updateTargetThreads: wrong arguments");
        }
    }

    public void propagateTargetThreads(int n, int n2) {
        if (n == 0) {
            this.targetThreads |= n2;
            if (this.parentTransformLink != null) {
                TargetsInterface targetsInterface = (TargetsInterface)((Object)this.parentTransformLink);
                targetsInterface.propagateTargetThreads(0, this.targetThreads);
            }
        } else {
            System.out.println("propagateTargetThreads: wrong arguments");
        }
    }

    public void updateCachedTargets(int n, CachedTargets[] cachedTargetsArray) {
        if (n == 0) {
            this.j3dCTs = cachedTargetsArray;
        } else {
            System.out.println("updateCachedTargets: wrong arguments");
        }
    }

    public void copyCachedTargets(int n, CachedTargets[] cachedTargetsArray) {
        if (n == 0) {
            int n2 = this.cachedTargets.length;
            int n3 = 0;
            while (n3 < n2) {
                cachedTargetsArray[n3] = this.cachedTargets[n3];
                ++n3;
            }
        } else {
            System.out.println("copyCachedTargets: wrong arguments");
        }
    }

    public void resetCachedTargets(int n, CachedTargets[] cachedTargetsArray, int n2) {
        if (n == 0) {
            this.cachedTargets = cachedTargetsArray;
        } else {
            System.out.println("resetCachedTargets: wrong arguments");
        }
    }

    public ArrayList getTargetsData(int n, int n2) {
        return null;
    }

    void childCheckSetLive(NodeRetained nodeRetained, int n, SetLiveState setLiveState, NodeRetained nodeRetained2) {
        setLiveState.currentTransforms = this.childLocalToVworld;
        setLiveState.currentTransformsIndex = this.childLocalToVworldIndex;
        setLiveState.parentTransformLink = this;
        setLiveState.childTransformLinks = this.childTransformLinks;
        setLiveState.localToVworld = setLiveState.currentTransforms;
        setLiveState.localToVworldIndex = setLiveState.currentTransformsIndex;
        nodeRetained.setLive(setLiveState);
    }
}

