package de.ugoe.cs.quest.tasktrees.treeimpl;

import de.ugoe.cs.quest.tasktrees.treeifc.IIteration;
import de.ugoe.cs.quest.tasktrees.treeifc.ISelection;
import de.ugoe.cs.quest.tasktrees.treeifc.ISequence;
import de.ugoe.cs.quest.tasktrees.treeifc.ITaskTreeBuilder;
import de.ugoe.cs.quest.tasktrees.treeifc.ITaskTreeNode;
import de.ugoe.cs.quest.tasktrees.treeifc.ITextInputEventTask;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: 21.02.2012$
 * @author 2012, last modified by $Author: patrick$
 */
public class TaskTreeBuilder implements ITaskTreeBuilder {

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.tasktree.treeifc.TaskTreeBuilder#addChild(Sequence, TaskTreeNode)
     */
    @Override
    public void addChild(ISequence parent, ITaskTreeNode child) {
        if (!(parent instanceof Sequence)) {
            throw new IllegalArgumentException
                ("illegal type of task tree node provided: " + parent.getClass());
        }

        addChildInternal(parent, -1, child);
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.tasktree.treeifc.TaskTreeBuilder#addChild(Sequence, int, TaskTreeNode)
     */
    @Override
    public void addChild(ISequence parent, int index, ITaskTreeNode child) {
        if (!(parent instanceof Sequence)) {
            throw new IllegalArgumentException
                ("illegal type of task tree node provided: " + parent.getClass());
        }

        addChildInternal(parent, index, child);
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.tasktree.treeifc.TaskTreeBuilder#addChild(Selection, TaskTreeNode)
     */
    @Override
    public void addChild(ISelection parent, ITaskTreeNode child) {
        if (!(parent instanceof Selection)) {
            throw new IllegalArgumentException
                ("illegal type of task tree node provided: " + parent.getClass());
        }

        addChildInternal(parent, -1, child);
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.tasktree.treeifc.TaskTreeBuilder#addChild(de.ugoe.cs.tasktree.treeifc.
     * TextInputEventTask, de.ugoe.cs.tasktree.treeifc.TaskTreeNode)
     */
    @Override
    public void addChild(ITextInputEventTask parent, ITaskTreeNode child) {
        if (!(parent instanceof TextInputEventTask)) {
            throw new IllegalArgumentException
                ("illegal type of task tree node provided: " + parent.getClass());
        }

        addChildInternal(parent, -1, child);
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.tasktree.treeifc.TaskTreeBuilder#setChild(Iteration, TaskTreeNode)
     */
    @Override
    public void setChild(IIteration iteration, ITaskTreeNode newChild) {
        if (!(iteration instanceof Iteration)) {
            throw new IllegalArgumentException
                ("illegal type of iteration provided: " + iteration.getClass());
        }

        if (!(newChild instanceof TaskTreeNode)) {
            throw new IllegalArgumentException
                ("illegal type of task tree node provided: " + newChild.getClass());
        }

        ((Iteration) iteration).setChild(newChild);
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.tasktree.treeifc.TaskTreeBuilder#removeChild(Sequence, int)
     */
    @Override
    public void removeChild(ISequence parent, int index) {
        if (!(parent instanceof TaskTreeNode)) {
            throw new IllegalArgumentException
                ("illegal type of task tree node provided: " + parent.getClass());
        }

        ((TaskTreeNode) parent).removeChild(index);
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.tasktree.treeifc.TaskTreeBuilder#removeChild(Selection, TaskTreeNode)
     */
    @Override
    public void removeChild(ISelection parent, ITaskTreeNode child) {
        if (!(parent instanceof TaskTreeNode)) {
            throw new IllegalArgumentException
                ("illegal type of task tree node provided: " + parent.getClass());
        }

        for (int i = 0; i < parent.getChildren().size(); i++) {
            if ((parent.getChildren().get(i) == child) ||
                ((parent.getChildren().get(i) != null) &&
                 (parent.getChildren().get(i).equals(child))))
            {
                ((TaskTreeNode) parent).removeChild(i);
                break;
            }
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.tasktree.treeifc.TaskTreeBuilder#setDescription(TaskTreeNode, String)
     */
    @Override
    public void setDescription(ITaskTreeNode parent, String description) {
        if (!(parent instanceof TaskTreeNode)) {
            throw new IllegalArgumentException
                ("illegal type of task tree node provided: " + parent.getClass());
        }

        ((TaskTreeNode) parent).setDescription(description);
    }

    /**
   * 
   */
    private void addChildInternal(ITaskTreeNode parent, int index, ITaskTreeNode child) {
        if (!(child instanceof TaskTreeNode)) {
            throw new IllegalArgumentException
                ("illegal type of task tree node provided: " + child.getClass());
        }

        if (index > -1) {
            ((TaskTreeNode) parent).addChild(index, child);
        }
        else {
            ((TaskTreeNode) parent).addChild(child);
        }
    }

}
