/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.guitar.util;

import edu.umd.cs.guitar.util.GUITARLog;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;

public class Util {
    private Util() {
    }

    public static List<String> getListFromFile(String sFileName, boolean isOrdered) {
        AbstractList retList = isOrdered ? new LinkedList() : new ArrayList();
        try {
            String line;
            ClassLoader cl = Util.class.getClassLoader();
            InputStream is = cl.getResourceAsStream(sFileName);
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).startsWith("//") || "".equals(line)) continue;
                retList.add((String)line);
            }
        }
        catch (FileNotFoundException e) {
            GUITARLog.log.error((Object)e);
        }
        catch (Exception e) {
            GUITARLog.log.error((Object)(sFileName + " not found"), (Throwable)e);
        }
        return retList;
    }

    @Deprecated
    public static void getCollectionFromFile(String sFileName, Collection<String> collection) {
        try {
            String line;
            BufferedReader is = new BufferedReader(new FileReader(sFileName));
            while ((line = is.readLine()) != null) {
                if ((line = line.trim()).startsWith("//") || "".equals(line)) continue;
                collection.add(line);
            }
        }
        catch (FileNotFoundException e) {
            GUITARLog.log.error((Object)e);
        }
        catch (IOException e) {
            GUITARLog.log.error((Object)e);
        }
    }

    public static String getTimeStamp() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddhhmmss");
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        return df.format(new Date());
    }
}

