package de.ugoe.cs.quest.tasktrees.temporalrelation;

import org.junit.Test;

import de.ugoe.cs.quest.eventcore.gui.ValueSelection;
import de.ugoe.cs.quest.eventcore.guimodel.IGUIElement;
import de.ugoe.cs.quest.eventcore.guimodel.ITrackBar;
import de.ugoe.cs.quest.tasktrees.testutils.DummyGUIElement;
import de.ugoe.cs.quest.tasktrees.testutils.DummyInteraction;
import de.ugoe.cs.quest.tasktrees.testutils.TaskTreeChecker;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: 28.04.2012$
 * @author 2012, last modified by $Author: patrick$
 */
public class TrackBarSelectionDetectionRuleTest extends AbstractTemporalRelationshipTC {

    /**
     *
     */
    @Test
    public void testSimpleDetection() throws Exception {
        IGUIElement element1 = new DummyTrackBar();
        simulateEvent(new ValueSelection<Integer>(1), element1);
        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence1 {" +
             "  Iteration interation1 {" +
             "    Selection selection1 {" +
             "      Event ValueSelection {}" +
             "    }" +
             "  }" +
             "}", getTaskTree());

        simulateEvent(new ValueSelection<Integer>(2), element1);
        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence1 {" +
             "  Iteration interation1 {" +
             "    Selection selection1 {" +
             "      Event ValueSelection {}" +
             "      Event ValueSelection {}" +
             "    }" +
             "  }" +
             "}", getTaskTree());

        simulateEvent(new ValueSelection<Integer>(3), element1);
        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence1 {" +
             "  Iteration interation1 {" +
             "    Selection selection1 {" +
             "      Event ValueSelection {}" +
             "      Event ValueSelection {}" +
             "      Event ValueSelection {}" +
             "    }" +
             "  }" +
             "}", getTaskTree());

        simulateEvent(new ValueSelection<Integer>(2), element1);
        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence1 {" +
             "  Iteration interation1 {" +
             "    Selection selection1 {" +
             "      Event ValueSelection {}" +
             "      Event ValueSelection {}" +
             "      Event ValueSelection {}" +
             "    }" +
             "  }" +
             "}", getTaskTree());

        simulateEvent(new ValueSelection<Integer>(3), element1);
        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence1 {" +
             "  Iteration interation1 {" +
             "    Selection selection1 {" +
             "      Event ValueSelection {}" +
             "      Event ValueSelection {}" +
             "      Event ValueSelection {}" +
             "    }" +
             "  }" +
             "}", getTaskTree());

    }

    /**
     *
     */
    @Test
    public void testComplexDetection() throws Exception {
        IGUIElement element1 = new DummyTrackBar();
        simulateEvent(new ValueSelection<Integer>(1), element1);
        simulateEvent(new ValueSelection<Integer>(2), element1);
        simulateEvent(new ValueSelection<Integer>(3), element1);
        simulateEvent(new ValueSelection<Integer>(1), element1);
        simulateEvent(new DummyInteraction("bla", 1), element1);
        simulateEvent(new DummyInteraction("bla", 2), element1);
        simulateEvent(new ValueSelection<Integer>(2), element1);
        simulateEvent(new ValueSelection<Integer>(1), element1);
        simulateEvent(new DummyInteraction("bla", 3), element1);
        simulateEvent(new ValueSelection<Integer>(3), element1);
        simulateEvent(new ValueSelection<Integer>(2), element1);
        simulateEvent(new ValueSelection<Integer>(3), element1);
        simulateEvent(new DummyInteraction("bla", 1), element1);
        simulateEvent(new DummyInteraction("bla", 2), element1);
        simulateEvent(new ValueSelection<Integer>(1), element1);
        simulateEvent(new ValueSelection<Integer>(1), element1);

        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence1 {" +
             "  Iteration interation1 {" +
             "    Selection selection1 {" +
             "      Event ValueSelection {}" +
             "      Event ValueSelection {}" +
             "      Event ValueSelection {}" +
             "    }" +
             "  }" +
             "  Event bla {}" +
             "  Event bla {}" +
             "  Iteration interation2 {" +
             "    Selection selection2 {" +
             "      Event ValueSelection {}" +
             "      Event ValueSelection {}" +
             "    }" +
             "  }" +
             "  Event bla {}" +
             "  Iteration interation3 {" +
             "    Selection selection3 {" +
             "      Event ValueSelection {}" +
             "      Event ValueSelection {}" +
             "    }" +
             "  }" +
             "  Event bla {}" +
             "  Event bla {}" +
             "  Iteration interation4 {" +
             "    Selection selection4 {" +
             "      Event ValueSelection {}" +
             "    }" +
             "  }" +
             "}", getTaskTree());
    }

    /**
     * TODO comment
     * 
     * @version $Revision: $ $Date: 28.04.2012$
     * @author 2012, last modified by $Author: patrick$
     */
    public class DummyTrackBar extends DummyGUIElement implements ITrackBar {

        /**  */
        private static final long serialVersionUID = 1L;

         /**
          *
          */
         public DummyTrackBar() {
            super("DummyTrackBar");
        }
    }

}
