package de.ugoe.cs.quest.plugin.jfc.eventcore;

import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: $
 * @author 2011, last modified by $Author: $
 */
public enum JFCEventId {
    
    MOUSE_CLICKED(MouseEvent.MOUSE_CLICKED),
    MOUSE_PRESSED(MouseEvent.MOUSE_PRESSED),
    MOUSE_RELEASED(MouseEvent.MOUSE_RELEASED),
    MOUSE_MOVED(MouseEvent.MOUSE_MOVED),
    MOUSE_ENTERED(MouseEvent.MOUSE_ENTERED),
    MOUSE_EXITED(MouseEvent.MOUSE_EXITED),
    MOUSE_DRAGGED(MouseEvent.MOUSE_DRAGGED),
    MOUSE_WHEEL(MouseEvent.MOUSE_WHEEL),
    FOCUS_GAINED(FocusEvent.FOCUS_GAINED),
    FOCUS_LOST(FocusEvent.FOCUS_LOST),
    KEY_TYPED(KeyEvent.KEY_TYPED),
    KEY_PRESSED(KeyEvent.KEY_PRESSED),
    KEY_RELEASED(KeyEvent.KEY_RELEASED);

    /** the numerical representation of the event type */
    private int mNumber;

    /**
     * @param number
     */
    JFCEventId(int number) {
        mNumber = number;
    }

    /**
     * @return Returns the number.
     */
    public int getNumber() {
        return mNumber;
    }

    /**
     *
     */
    public static JFCEventId parseEventId(String numberString) {
        try {
            int number = Integer.parseInt(numberString);
            return valueOf(number);
        }
        catch (NumberFormatException e) {
            return JFCEventId.valueOf(JFCEventId.class, numberString);
        }
    }

    /**
     *
     */
    public static JFCEventId valueOf(int number) {
        for (JFCEventId type : JFCEventId.values()) {
            if (type.mNumber == number) {
                return type;
            }
        }

        throw new IllegalArgumentException("there is no event type with number " + number);
    }

}
