package de.ugoe.cs.quest.plugin.mfc.commands;

import java.security.InvalidParameterException;
import java.util.Collection;
import java.util.List;

import de.ugoe.cs.quest.CommandHelpers;
import de.ugoe.cs.quest.eventcore.Event;
import de.ugoe.cs.quest.eventcore.guimodel.GUIModel;
import de.ugoe.cs.quest.plugin.mfc.MFCLogParser;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.GlobalDataContainer;

/**
 * <p>
 * Command to parse an XML file with sessions monitored by EventBench's MFCUsageMonitor.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDparseXML implements Command {

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.util.console.Command#help()
     */
    @Override
    public String help() {
        return "parseXML <filename> {<sequencesName>} {<countMessageOccurences>}";
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.util.console.Command#run(java.util.List)
     */
    @Override
    public void run(List<Object> parameters) {
        String filename;
        String sequencesName = "sequences";
        boolean countMessageOccurences = false;

        try {
            filename = (String) parameters.get(0);
            if (parameters.size() >= 2) {
                sequencesName = (String) parameters.get(1);
            }
            if (parameters.size() >= 3) {
                countMessageOccurences = Boolean.parseBoolean((String) parameters.get(2));
            }
        }
        catch (Exception e) {
            throw new InvalidParameterException();
        }

        MFCLogParser parser = new MFCLogParser(countMessageOccurences);
        parser.parseFile(filename);

        Collection<List<Event>> sequences = parser.getSequences();

        GUIModel targets = parser.getGuiModel();

        if (GlobalDataContainer.getInstance().addData(sequencesName, sequences)) {
            CommandHelpers.dataOverwritten(sequencesName);
        }
        if (GlobalDataContainer.getInstance().addData(sequencesName + "_targets", targets)) {
            CommandHelpers.dataOverwritten(sequencesName + "_targets");
        }
    }

}
