package de.ugoe.cs.quest.tasktrees.nodeequality;

import static org.junit.Assert.*;

import org.junit.Test;

import de.ugoe.cs.quest.tasktrees.treeifc.ISequence;
import de.ugoe.cs.quest.tasktrees.treeifc.ITaskTreeBuilder;
import de.ugoe.cs.quest.tasktrees.treeifc.ITaskTreeNode;
import de.ugoe.cs.quest.tasktrees.treeifc.ITaskTreeNodeFactory;
import de.ugoe.cs.quest.tasktrees.treeimpl.TaskTreeBuilder;
import de.ugoe.cs.quest.tasktrees.treeimpl.TaskTreeNodeFactory;
import de.ugoe.cs.quest.tasktrees.treeimpl.TaskTreeNode;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @version $Revision: $ $Date: 16.08.2012$
 * @author 2012, last modified by $Author: pharms$
 */
public class SequenceComparisonRuleTest {

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     */
    @Test
    public void test() {
        NodeEqualityRuleManager manager = new NodeEqualityRuleManager();
        manager.init();
        
        ITaskTreeNodeFactory treeNodeFactory = new TaskTreeNodeFactory();
        ITaskTreeBuilder treeBuilder = new TaskTreeBuilder();
        
        SequenceComparisonRule rule = new SequenceComparisonRule(manager);
        
        ITaskTreeNode task1 = new TaskTreeNode("task1");
        ITaskTreeNode task2 = new TaskTreeNode("task2");
        
        assertNull(rule.compare(task1, task2));
        
        ISequence sequence1 = treeNodeFactory.createNewSequence();
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(sequence1, sequence1));

        ISequence sequence2 = treeNodeFactory.createNewSequence();
        
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(sequence1, sequence2));
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(sequence2, sequence1));
        
        treeBuilder.addChild(sequence1, task1);
        
        assertNull(rule.compare(sequence1, sequence2));
        assertNull(rule.compare(sequence2, sequence1));
        
        treeBuilder.addChild(sequence2, task1);
        
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(sequence1, sequence2));
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(sequence2, sequence1));
        
        treeBuilder.addChild(sequence1, task2);
        
        assertNull(rule.compare(sequence1, sequence2));
        assertNull(rule.compare(sequence2, sequence1));
        
        treeBuilder.addChild(sequence2, task2);
        
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(sequence1, sequence2));
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(sequence2, sequence1));
        
        ISequence sequence3 = treeNodeFactory.createNewSequence();
        treeBuilder.addChild(sequence3, task2);
        treeBuilder.addChild(sequence3, task1);
        
        assertNull(rule.compare(sequence1, sequence3));
        assertNull(rule.compare(sequence3, sequence1));
    }

}
