package de.ugoe.cs.quest.tasktrees.treeimpl;

import de.ugoe.cs.quest.eventcore.IEventTarget;
import de.ugoe.cs.quest.eventcore.gui.TextInput;
import de.ugoe.cs.quest.tasktrees.treeifc.ITextInputEventTask;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: 10.06.2012$
 * @author 2012, last modified by $Author: patrick$
 */
public class TextInputEventTask extends EventTask implements ITextInputEventTask {

    /** the text, that was finally entered in this sequence without all backspaces, etc. */
    private String enteredText;

    /**
     * TODO: comment
     * 
     * @param name
     */
    TextInputEventTask(IEventTarget eventTarget) {
        super(new TextInput(), eventTarget);
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.tasktree.treeimpl.TaskTreeNodeImpl#clone()
     */
    @Override
    public TextInputEventTask clone() {
        // entered text is unchangeable and does not need to be cloned
        return (TextInputEventTask) super.clone();
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.tasktree.treeifc.TextInputSequence#getEnteredText()
     */
    @Override
    public String getEnteredText() {
        return enteredText;
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.tasktree.treeifc.TextInputSequence#setEnteredText(java.lang.String)
     */
    @Override
    public void setEnteredText(String text) {
        enteredText = text;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public synchronized String toString() {
        if (super.getChildren() == null) {
            return super.getName();
        }
        else {
            return
                "TextInputInteraction(\"" + enteredText + "\", " + super.getChildren().size() +
                " children)";
        }
    }

}
