package de.ugoe.cs.quest.ui.commands;

import java.security.InvalidParameterException;
import java.util.List;

import de.ugoe.cs.quest.CommandHelpers;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.GlobalDataContainer;

/**
 * <p>
 * Command to delete object from {@link GlobalDataContainer}.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDdeleteObject implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public String help() {
		return "deleteObject <objectname>";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@Override
	public void run(List<Object> parameters) {
		String objectName;
		try {
			objectName = (String) parameters.get(0);
		} catch (Exception e) {
			throw new InvalidParameterException();
		}
		boolean deleted = GlobalDataContainer.getInstance().removeData(
				objectName);
		if (!deleted) {
			CommandHelpers.objectNotFoundMessage(objectName);
		}
	}
}
