/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.bcel.classfile.Code;

public class RepeatedConditionals
extends OpcodeStackDetector {
    BugReporter bugReporter;
    int oldPC;
    LinkedList<Integer> emptyStackLocations = new LinkedList();
    LinkedList<Integer> prevOpcodeLocations = new LinkedList();
    Map<Integer, Integer> branchTargets = new HashMap<Integer, Integer>();

    public RepeatedConditionals(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.reset();
    }

    public void visit(Code code) {
        boolean interesting = true;
        if (interesting) {
            super.visit(code);
            this.reset();
        }
    }

    public void sawBranchTo(int pc) {
        this.branchTargets.put(this.getPC(), pc);
    }

    public void sawOpcode(int seen) {
        if (this.isRegisterStore() || this.isReturn(seen) || RepeatedConditionals.isSwitch(seen) || seen == 185 || seen == 183 || seen == 184 || seen == 182 || seen == 181 || seen == 179) {
            this.reset();
        } else if (this.stack.getStackDepth() == 0) {
            block13: {
                if (this.emptyStackLocations.size() > 1) {
                    int first = this.emptyStackLocations.get(this.emptyStackLocations.size() - 2);
                    int second = this.emptyStackLocations.get(this.emptyStackLocations.size() - 1);
                    int third = this.getPC();
                    if (third - second == second - first) {
                        int endOfFirstSegment = this.prevOpcodeLocations.get(this.emptyStackLocations.size() - 1);
                        int endOfSecondSegment = this.oldPC;
                        int opcodeAtEndOfFirst = this.getCodeByte(endOfFirstSegment);
                        int opcodeAtEndOfSecond = this.getCodeByte(endOfSecondSegment);
                        if (RepeatedConditionals.isBranch(opcodeAtEndOfFirst) && RepeatedConditionals.isBranch(opcodeAtEndOfSecond) && opcodeAtEndOfFirst != 167 && opcodeAtEndOfSecond != 167 && (opcodeAtEndOfFirst == opcodeAtEndOfSecond || RepeatedConditionals.areOppositeBranches(opcodeAtEndOfFirst, opcodeAtEndOfSecond))) {
                            byte[] code = this.getCode().getCode();
                            if (first != endOfFirstSegment) {
                                for (int i = first; i < endOfFirstSegment; ++i) {
                                    if (code[i] == code[i - first + second]) {
                                        continue;
                                    }
                                    break block13;
                                }
                                SourceLineAnnotation firstSourceLine = SourceLineAnnotation.fromVisitedInstructionRange(this.getClassContext(), this, first, endOfFirstSegment - 1);
                                SourceLineAnnotation secondSourceLine = SourceLineAnnotation.fromVisitedInstructionRange(this.getClassContext(), this, second, endOfSecondSegment - 1);
                                int priority = 1;
                                if (firstSourceLine.getStartLine() == -1 || firstSourceLine.getStartLine() != secondSourceLine.getEndLine()) {
                                    ++priority;
                                }
                                if (this.stack.isJumpTarget(second)) {
                                    ++priority;
                                }
                                Integer firstTarget = this.branchTargets.get(endOfFirstSegment);
                                Integer secondTarget = this.branchTargets.get(endOfSecondSegment);
                                if (firstTarget != null && secondTarget != null) {
                                    if (!(firstTarget.equals(secondTarget) && opcodeAtEndOfFirst == opcodeAtEndOfSecond || firstTarget.intValue() == this.getPC())) {
                                        priority += 2;
                                    }
                                    BugInstance bug = new BugInstance(this, "RpC_REPEATED_CONDITIONAL_TEST", priority).addClassAndMethod(this).add(firstSourceLine).add(secondSourceLine);
                                    this.bugReporter.reportBug(bug);
                                }
                            }
                        }
                    }
                }
            }
            this.emptyStackLocations.add(this.getPC());
            this.prevOpcodeLocations.add(this.oldPC);
        }
        this.oldPC = this.getPC();
    }

    private void reset() {
        this.emptyStackLocations.clear();
        this.prevOpcodeLocations.clear();
        this.branchTargets.clear();
        this.oldPC = -1;
    }
}

