/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BoundingBox;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.LightRetained;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroupRetained;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;

class PointLightRetained
extends LightRetained {
    static final int POSITION_CHANGED = 128;
    static final int ATTENUATION_CHANGED = 256;
    static final int LAST_POINTLIGHT_DEFINED_BIT = 256;
    Point3f attenuation = new Point3f(1.0f, 0.0f, 0.0f);
    Point3f position = new Point3f();
    Point3f xformPosition = new Point3f();
    double localToVworldScale;
    float linearAttenuationInEc;
    float quadraticAttenuationInEc;

    PointLightRetained() {
        this.nodeType = 7;
        this.lightType = 3;
        this.localBounds = new BoundingBox();
        ((BoundingBox)this.localBounds).setLower(1.0, 1.0, 1.0);
        ((BoundingBox)this.localBounds).setUpper(-1.0, -1.0, -1.0);
    }

    void initPosition(Point3f point3f) {
        this.position.set((Tuple3f)point3f);
        if (this.staticTransform != null) {
            this.staticTransform.transform.transform(this.position, this.position);
        }
    }

    void setPosition(Point3f point3f) {
        this.initPosition(point3f);
        this.sendMessage(128, new Point3f(point3f));
    }

    void initPosition(float f, float f2, float f3) {
        this.position.x = f;
        this.position.y = f2;
        this.position.z = f3;
        if (this.staticTransform != null) {
            this.staticTransform.transform.transform(this.position, this.position);
        }
    }

    void setPosition(float f, float f2, float f3) {
        this.setPosition(new Point3f(f, f2, f3));
    }

    void getPosition(Point3f point3f) {
        point3f.set((Tuple3f)this.position);
        if (this.staticTransform != null) {
            Transform3D transform3D = this.staticTransform.getInvTransform();
            transform3D.transform(point3f, point3f);
        }
    }

    void initAttenuation(Point3f point3f) {
        this.attenuation.set((Tuple3f)point3f);
    }

    void setAttenuation(Point3f point3f) {
        this.initAttenuation(point3f);
        this.sendMessage(256, new Point3f(point3f));
    }

    void initAttenuation(float f, float f2, float f3) {
        this.attenuation.x = f;
        this.attenuation.y = f2;
        this.attenuation.z = f3;
    }

    void setAttenuation(float f, float f2, float f3) {
        this.setAttenuation(new Point3f(f, f2, f3));
    }

    void getAttenuation(Point3f point3f) {
        point3f.set((Tuple3f)this.attenuation);
    }

    native void updateLight(long var1, int var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11, float var12);

    void update(long l, int n, double d) {
        this.validateAttenuationInEc(d);
        this.updateLight(l, n, this.color.x, this.color.y, this.color.z, this.attenuation.x, this.linearAttenuationInEc, this.quadraticAttenuationInEc, this.xformPosition.x, this.xformPosition.y, this.xformPosition.z);
    }

    void setLive(SetLiveState setLiveState) {
        super.setLive(setLiveState);
        J3dMessage j3dMessage = super.initMessage(9);
        Object[] objectArray = (Object[])j3dMessage.args[4];
        objectArray[7] = new Point3f(this.position);
        objectArray[8] = new Point3f(this.attenuation);
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    void doSetLive(SetLiveState setLiveState) {
        super.setLive(setLiveState);
    }

    J3dMessage initMessage(int n) {
        J3dMessage j3dMessage = super.initMessage(n);
        Object[] objectArray = (Object[])j3dMessage.args[4];
        objectArray[7] = new Point3f(this.position);
        objectArray[8] = new Point3f(this.attenuation);
        return j3dMessage;
    }

    void updateMirrorObject(Object[] objectArray) {
        int n = (Integer)objectArray[1];
        int n2 = (Integer)objectArray[2];
        LightRetained[] lightRetainedArray = (LightRetained[])objectArray[3];
        if ((n & 0x80) != 0) {
            int n3 = 0;
            while (n3 < n2) {
                if (lightRetainedArray[n3] instanceof PointLightRetained) {
                    PointLightRetained pointLightRetained = (PointLightRetained)lightRetainedArray[n3];
                    Transform3D transform3D = pointLightRetained.getLastLocalToVworld();
                    pointLightRetained.position = (Point3f)objectArray[4];
                    transform3D.transform(pointLightRetained.position, pointLightRetained.xformPosition);
                    pointLightRetained.localToVworldScale = transform3D.getDistanceScale();
                }
                ++n3;
            }
        } else if ((n & 0x100) != 0) {
            int n4 = 0;
            while (n4 < n2) {
                if (lightRetainedArray[n4] instanceof PointLightRetained) {
                    PointLightRetained pointLightRetained = (PointLightRetained)lightRetainedArray[n4];
                    pointLightRetained.attenuation.set((Tuple3f)((Point3f)objectArray[4]));
                }
                ++n4;
            }
        } else if ((n & 0x20) != 0) {
            int n5 = 0;
            while (n5 < n2) {
                if (lightRetainedArray[n5] instanceof PointLightRetained) {
                    PointLightRetained pointLightRetained = (PointLightRetained)this.mirrorLights[n5];
                    pointLightRetained.position = (Point3f)((Object[])objectArray[4])[7];
                    pointLightRetained.attenuation.set((Tuple3f)((Point3f)((Object[])objectArray[4])[8]));
                    Transform3D transform3D = pointLightRetained.getLastLocalToVworld();
                    transform3D.transform(pointLightRetained.position, pointLightRetained.xformPosition);
                    pointLightRetained.localToVworldScale = transform3D.getDistanceScale();
                }
                ++n5;
            }
        }
        super.updateMirrorObject(objectArray);
    }

    void validateAttenuationInEc(double d) {
        double d2 = this.localToVworldScale * d;
        this.linearAttenuationInEc = (float)((double)this.attenuation.y / d2);
        this.quadraticAttenuationInEc = (float)((double)this.attenuation.z / (d2 * d2));
    }

    protected Object clone() {
        PointLightRetained pointLightRetained = (PointLightRetained)super.clone();
        pointLightRetained.attenuation = new Point3f(this.attenuation);
        pointLightRetained.position = new Point3f(this.position);
        pointLightRetained.xformPosition = new Point3f();
        return pointLightRetained;
    }

    void updateTransformChange() {
        super.updateTransformChange();
        Transform3D transform3D = this.getLastLocalToVworld();
        transform3D.transform(this.position, this.xformPosition);
        this.localToVworldScale = transform3D.getDistanceScale();
        this.validateAttenuationInEc(0.0861328125);
    }

    void sendMessage(int n, Object object) {
        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = 4224;
        j3dMessage.universe = this.universe;
        j3dMessage.type = 19;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(n);
        j3dMessage.args[2] = this.inSharedGroup ? new Integer(this.numMirrorLights) : new Integer(1);
        j3dMessage.args[3] = this.mirrorLights.clone();
        j3dMessage.args[4] = object;
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    void mergeTransform(TransformGroupRetained transformGroupRetained) {
        super.mergeTransform(transformGroupRetained);
        transformGroupRetained.transform.transform(this.position, this.position);
    }
}

