package de.ugoe.cs.quest.plugin.jfc.commands;

import java.io.File;
import java.security.InvalidParameterException;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;

import de.ugoe.cs.quest.CommandHelpers;
import de.ugoe.cs.quest.eventcore.Event;
import de.ugoe.cs.quest.plugin.jfc.JFCLogParser;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;
import de.ugoe.cs.util.console.GlobalDataContainer;

/**
 * <p>
 * Command that tries to parse all files in a folder as if they were log files generated by the
 * JFCMonitor. The result is one set of sequences for all files (not one set of sequences for each
 * file!).
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDparseDirJFC implements Command {

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.util.console.Command#run(java.util.List)
     */
    @Override
    public void run(List<Object> parameters) {
        String path;
        String sequencesName = "sequences";

        try {
            path = (String) parameters.get(0);
            if (parameters.size() >= 2) {
                sequencesName = (String) parameters.get(1);
            }
        }
        catch (Exception e) {
            throw new InvalidParameterException();
        }

        File folder = new File(path);
        if (!folder.isDirectory()) {
            Console.printerrln(path + " is not a directory");
            return;
        }

        JFCLogParser parser = new JFCLogParser();

        String absolutPath = folder.getAbsolutePath();
        for (String filename : folder.list()) {
            String source = absolutPath + "/" + filename;
            Console.traceln(Level.INFO, "Processing file: " + source);

            parser.parseFile(source);
        }

        Collection<List<Event>> sequences = parser.getSequences();

        if (GlobalDataContainer.getInstance().addData(sequencesName, sequences)) {
            CommandHelpers.dataOverwritten(sequencesName);
        }

    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.util.console.Command#help()
     */
    @Override
    public String help() {
        return "parseDirJFC <path> {<sequencesName>}";
    }

}
