package de.ugoe.cs.eventbench.web.data;

import java.util.List;

import de.ugoe.cs.eventbench.data.ReplayableEvent;

public class WebEvent extends ReplayableEvent<WebRequest> {

	private final long timestamp;
	private String uri;
	
	private final static String makeType(String uri, List<String> postVars) {
		String type = uri;
		if( postVars!=null && !postVars.isEmpty() ) {
			type += postVars.toString().replace(" ", "");
		}
		return type;
	}
	
	public WebEvent(String uri, long timestamp, List<String> postVars) {
		super(makeType(uri, postVars));
		this.timestamp = timestamp;
		this.uri = uri;
		addReplayEvent(new WebRequest(uri, postVars));
	}
	
	public long getTimestamp() {
		return timestamp;
	}

}
