package de.ugoe.cs.quest.ui.swt;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;

import de.ugoe.cs.quest.assertions.FileEqualsAssertEventType;
import de.ugoe.cs.quest.assertions.FileEqualsReplay;
import de.ugoe.cs.quest.eventcore.Event;
import de.ugoe.cs.quest.eventcore.guimodel.GUIModel;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;

public class InsertFileEquals extends AbstractInsertEventComposite {
    private Text actualText;
    private Text expectedText;

    public InsertFileEquals(Composite parent, int style) {
        this(parent, style, null);
    }

    /**
     * Create the composite.
     * 
     * @param parent
     * @param style
     */
    public InsertFileEquals(Composite parent, int style, GUIModel guiModel) {
        super(parent, style, guiModel);
        setLayout(new GridLayout(3, false));

        Label lblExpectedFile = new Label(this, SWT.NONE);
        lblExpectedFile.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
        lblExpectedFile.setText("Expected file:");

        expectedText = new Text(this, SWT.BORDER);
        expectedText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));

        Button btnSearch = new Button(this, SWT.NONE);
        btnSearch.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(getShell(), SWT.OPEN);
                String filename = fileDialog.open();
                if (filename != null) {
                    expectedText.setText(filename);
                }
            }
        });
        btnSearch.setText("Search...");

        Label lblActualFile = new Label(this, SWT.NONE);

        lblActualFile.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
        lblActualFile.setText("Actual file:");

        actualText = new Text(this, SWT.BORDER);
        actualText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
        new Label(this, SWT.NONE);

    }

    @Override
    protected void checkSubclass() {
        // Disable the check that prevents subclassing of SWT components
    }

    @Override
    public Event getEvent() {
        FileEqualsReplay replay =
            new FileEqualsReplay(expectedText.getText(), actualText.getText());
        Event event = new Event(new FileEqualsAssertEventType());
        event.addReplayable(replay);
        return event;
    }

}
