/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.guitar.event;

import edu.umd.cs.guitar.event.GEvent;
import edu.umd.cs.guitar.model.GComponent;
import edu.umd.cs.guitar.util.GUITARLog;
import java.util.Hashtable;
import java.util.List;

public abstract class GThreadEvent
implements GEvent {
    static DispatchThreadGroup threadGroup;

    public GThreadEvent() {
        if (threadGroup == null) {
            threadGroup = new DispatchThreadGroup("GThreadEvent group");
        }
    }

    @Override
    public void perform(GComponent gComponent, List<String> parameters, Hashtable<String, List<String>> optionalData) {
        Thread t = new Thread((ThreadGroup)threadGroup, new DispatchThread(gComponent, parameters, optionalData));
        t.start();
    }

    @Override
    public void perform(GComponent gComponent, Hashtable<String, List<String>> optionalData) {
        Thread t = new Thread((ThreadGroup)threadGroup, new DispatchThread(gComponent, optionalData));
        t.start();
    }

    protected abstract void performImpl(GComponent var1, Hashtable<String, List<String>> var2);

    protected abstract void performImpl(GComponent var1, Object var2, Hashtable<String, List<String>> var3);

    private class DispatchThread
    implements Runnable {
        GComponent gComponent;
        Object parameters = null;
        Hashtable<String, List<String>> optionalData = null;

        public DispatchThread(GComponent gComponent, Hashtable<String, List<String>> optionalData) {
            this.gComponent = gComponent;
            this.optionalData = optionalData;
        }

        public DispatchThread(GComponent gComponent, Object parameters, Hashtable<String, List<String>> optionalData) {
            this.gComponent = gComponent;
            this.parameters = parameters;
            this.optionalData = optionalData;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            GComponent gComponent = this.gComponent;
            synchronized (gComponent) {
                if (this.parameters == null) {
                    GThreadEvent.this.performImpl(this.gComponent, this.optionalData);
                } else {
                    GThreadEvent.this.performImpl(this.gComponent, this.parameters, this.optionalData);
                }
            }
        }
    }

    class DispatchThreadGroup
    extends ThreadGroup {
        public DispatchThreadGroup(String name) {
            super(name);
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            GUITARLog.log.error((Object)(this.getName() + " uncaught Exception!!!"), e);
            throw (RuntimeException)e;
        }
    }
}

