
package de.ugoe.cs.quest.ui.swt;

import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

import de.ugoe.cs.quest.eventcore.guimodel.GUIModel;
import de.ugoe.cs.quest.eventcore.guimodel.IGUIElement;
import org.eclipse.swt.widgets.Label;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @version $Revision: $ $Date: Aug 28, 2012$
 * @author 2012, last modified by $Author: sherbold$
 */
public class ShowGuiModelDialog extends Dialog {

    protected Object result;
    protected Shell shell;
    private Tree guiTree;

    protected GUIModel model;

    /**
     * Create the dialog.
     * 
     * @param parent
     * @param style
     */
    public ShowGuiModelDialog(Shell parent, int style, GUIModel model, String modelName) {
        super(parent, style);
        setText("GUI Model " + modelName);
        this.model = model;
    }

    /**
     * Open the dialog.
     * 
     * @return the result
     */
    public Object open() {
        createContents();
        shell.open();
        shell.layout();
        Display display = getParent().getDisplay();
        while (!shell.isDisposed()) {
            if (!display.readAndDispatch()) {
                display.sleep();
            }
        }
        return result;
    }

    /**
     * Create contents of the dialog.
     */
    private void createContents() {
        shell = new Shell(getParent(), SWT.SHELL_TRIM | SWT.BORDER | SWT.APPLICATION_MODAL);
        shell.setSize(450, 300);
        shell.setText(getText());

        shell.setLayout(new GridLayout(2, false));

        guiTree = new Tree(shell, SWT.BORDER);
        guiTree.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1));

        buildGuiTree();

        Button btnExpandAll = new Button(shell, SWT.NONE);
        btnExpandAll.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                expandAll(guiTree, true);
            }
        });
        btnExpandAll.setText("Expand all");

        Button btnCollapseAll = new Button(shell, SWT.NONE);
        btnCollapseAll.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                expandAll(guiTree, false);
            }
        });
        btnCollapseAll.setText("Collapse all");
        new Label(shell, SWT.NONE);
        new Label(shell, SWT.NONE);

    }

    private void buildGuiTree() {
        for (IGUIElement element : model.getRootElements()) {
            TreeItem child = new TreeItem(guiTree, SWT.NULL);
            child.setText(element.toString());
            buildGuiTree(child, model.getChildren(element));
        }
    }

    private void buildGuiTree(TreeItem currentParent, List<IGUIElement> elements) {
        for (IGUIElement element : elements) {
            TreeItem child = new TreeItem(currentParent, SWT.NULL);
            child.setText(element.toString());
            buildGuiTree(child, model.getChildren(element));
        }
    }

    private void expandAll(Tree tree, boolean expanded) {
        for (TreeItem item : tree.getItems()) {
            expandAll(item, expanded);
        }
    }

    private void expandAll(TreeItem item, boolean expanded) {
        item.setExpanded(expanded);
        for (TreeItem childItem : item.getItems()) {
            expandAll(childItem, expanded);
        }
    }

}
