package de.ugoe.cs.quest.tasktrees.nodeequality;

import de.ugoe.cs.quest.tasktrees.treeifc.ITaskTreeNode;

/**
 * <p>
 * This comparison rule returns <code>NodeEquality.IDENTICAL</code> if the comparison of the two
 * task tree nodes using the <code>==</code> operator or the <code>equals</code> method return true.
 * Else it returns null to denote, that it can not compare the nodes.
 * </p>
 * 
 * @version $Revision: $ $Date: 19.02.2012$
 * @author 2012, last modified by $Author: patrick$
 */
public class NodeIdentityRule implements NodeComparisonRule {

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.tasktree.nodeequality.NodeEqualityRule#apply(TaskTreeNode, TaskTreeNode)
     */
    @Override
    public NodeEquality compare(ITaskTreeNode node1, ITaskTreeNode node2) {
        if ((node1 == node2) || ((node1 != null) && (node1.equals(node2)))) {
            return NodeEquality.IDENTICAL;
        }
        else {
            return null;
        }
    }

}
