/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.util;

import edu.umd.cs.findbugs.util.MapCache;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfilingMapCache<K, V>
extends MapCache<K, V> {
    final String name;
    int[] count;

    public ProfilingMapCache(int maxCapacity, String name) {
        super(maxCapacity);
        this.name = name;
        this.count = new int[maxCapacity];
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                System.out.println("Profile for map cache " + ProfilingMapCache.this.name);
                for (int i = 0; i < ProfilingMapCache.this.count.length; ++i) {
                    System.out.printf("%4d %5d%n", i, ProfilingMapCache.this.count[i]);
                }
            }
        });
    }

    @Override
    public V get(Object k) {
        int age = this.count.length - 1;
        for (Map.Entry e : this.entrySet()) {
            if (e.getKey().equals(k)) {
                int n = age;
                this.count[n] = this.count[n] + 1;
                if (age <= 20) break;
                new RuntimeException("Reusing value from " + age + " steps ago in " + this.name).printStackTrace(System.out);
                break;
            }
            --age;
        }
        return super.get(k);
    }

    public String getStatistics() {
        StringBuilder b = new StringBuilder();
        for (int c : this.count) {
            b.append(c).append(" ");
        }
        return b.toString();
    }
}

