package de.ugoe.cs.quest.eventcore;

import java.security.InvalidParameterException;

/**
 * <p>
 * A simple event type that is identified by a string.
 * </p>
 * 
 * @version $Revision: $ $Date: Aug 16, 2012$
 * @author 2012, last modified by $Author: sherbold$
 */
public class StringEventType implements IEventType {

    /**
     * <p>
     * Id for object serialization.
     * </p>
     */
    private static final long serialVersionUID = 1L;

    /**
     * <p>
     * String that identifies the event type.
     * </p>
     */
    private String str;

    /**
     * <p>
     * Constructor. Creates a new StringEventType. str must not be null.
     * </p>
     * 
     * @param str
     *            string that identifies the event type
     * @throws InvalidParameterException
     *             thrown if str is null
     */
    public StringEventType(String str) throws InvalidParameterException {
        if (str == null) {
            throw new InvalidParameterException("str must not be null");
        }
        this.str = str;
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.quest.eventcore.IEventType#getName()
     */
    @Override
    public String getName() {
        return "StringEventType";
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return str;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        return str.hashCode();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof StringEventType) {
            return str.equals(((StringEventType) other).str);
        }
        return false;
    }
}
