package de.ugoe.cs.quest.tasktrees.temporalrelation;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import org.junit.Before;

import de.ugoe.cs.quest.eventcore.IEventTarget;
import de.ugoe.cs.quest.eventcore.IEventType;
import de.ugoe.cs.quest.tasktrees.nodeequality.NodeEqualityRuleManager;
import de.ugoe.cs.quest.tasktrees.testutils.SimpleLogFormatter;
import de.ugoe.cs.quest.tasktrees.testutils.Utilities;
import de.ugoe.cs.quest.tasktrees.treeifc.IEventTask;
import de.ugoe.cs.quest.tasktrees.treeifc.ISequence;
import de.ugoe.cs.quest.tasktrees.treeifc.ITaskTree;
import de.ugoe.cs.quest.tasktrees.treeifc.ITaskTreeBuilder;
import de.ugoe.cs.quest.tasktrees.treeifc.ITaskTreeNodeFactory;
import de.ugoe.cs.quest.tasktrees.treeimpl.TaskTreeBuilder;
import de.ugoe.cs.quest.tasktrees.treeimpl.TaskTreeNodeFactory;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: 28.04.2012$
 * @author 2012, last modified by $Author: patrick$
 */
public class AbstractTemporalRelationshipTC {

    /** */
    private List<IEventTask> events;

    /** */
    private ITaskTreeBuilder taskTreeBuilder = new TaskTreeBuilder();

    /** */
    private ITaskTreeNodeFactory taskTreeNodeFactory = new TaskTreeNodeFactory();

    /** */
    private NodeEqualityRuleManager nodeEqualityRuleManager =
        Utilities.getNodeEqualityRuleManagerForTests();

    /**
   *
   */
    @Before
    public void setUp() {
        Logger.getLogger("").getHandlers()[0].setFormatter(new SimpleLogFormatter());
        events = new ArrayList<IEventTask>();
    }

    /**
     *
     */
    protected void simulateEvent(IEventType eventType, IEventTarget eventTarget) {
        events.add(taskTreeNodeFactory.createNewEventTask(eventType, eventTarget));
    }

    /**
     *
     * @return
     */
    protected ITaskTree getTaskTree() {
        ISequence sequence = taskTreeNodeFactory.createNewSequence();

        for (IEventTask task : events) {
            taskTreeBuilder.addChild(sequence, task);
        }

        TemporalRelationshipRuleManager ruleManager =
            new TemporalRelationshipRuleManager(nodeEqualityRuleManager);

        ruleManager.init();
        ruleManager.applyRules(sequence, taskTreeBuilder, taskTreeNodeFactory, true);

        return taskTreeNodeFactory.createTaskTree(sequence);
    }

}
