package de.ugoe.cs.quest.tasktrees.temporalrelation;

import org.junit.Test;

import de.ugoe.cs.quest.eventcore.gui.MouseButtonDown;
import de.ugoe.cs.quest.eventcore.gui.MouseButtonInteraction;
import de.ugoe.cs.quest.eventcore.gui.MouseButtonUp;
import de.ugoe.cs.quest.eventcore.gui.MouseClick;
import de.ugoe.cs.quest.eventcore.guimodel.IGUIElement;
import de.ugoe.cs.quest.tasktrees.testutils.TaskTreeChecker;
import de.ugoe.cs.quest.test.DummyGUIElement;
import de.ugoe.cs.quest.test.DummyInteraction;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: $
 * @author 2011, last modified by $Author: $
 */
public class DefaultMouseClickReductionRuleTest extends AbstractTemporalRelationshipTC {

    /**
     *
     */
    @Test
    public void testMouseClickInOneSequenceElement() {
        MouseButtonInteraction.Button leftBtn = MouseButtonInteraction.Button.LEFT;
        MouseButtonInteraction.Button middleBtn = MouseButtonInteraction.Button.MIDDLE;
        MouseButtonInteraction.Button rightBtn = MouseButtonInteraction.Button.RIGHT;

        IGUIElement element1 = new DummyGUIElement("elem1");
        IGUIElement element2 = new DummyGUIElement("elem1");

        simulateEvent(new MouseButtonDown(leftBtn), element1);
        simulateEvent(new MouseButtonUp(leftBtn), element1);
        simulateEvent(new MouseClick(leftBtn), element1);

        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence {" +
             "  Event LeftMouseClick {}" +
             "}", getTaskTree());

        simulateEvent(new DummyInteraction("bla", 1), element1);
        simulateEvent(new DummyInteraction("bli", 1), element1);
        simulateEvent(new MouseButtonDown(middleBtn), element1);
        simulateEvent(new MouseButtonUp(middleBtn), element1);
        simulateEvent(new MouseClick(middleBtn), element1);
        simulateEvent(new DummyInteraction("blo", 1), element1);
        simulateEvent(new DummyInteraction("blu", 1), element1);

        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence {" +
             "  Event LeftMouseClick {}" +
             "  Event bla {}" +
             "  Event bli {}" +
             "  Event MiddleMouseClick {}" +
             "  Event blo {}" +
             "  Event blu {}" +
             "}", getTaskTree());

        simulateEvent(new DummyInteraction("bla", 1), element2);
        simulateEvent(new DummyInteraction("bli", 1), element2);
        simulateEvent(new MouseButtonDown(rightBtn), element2);
        simulateEvent(new MouseButtonUp(rightBtn), element2);
        simulateEvent(new MouseClick(rightBtn), element2);
        simulateEvent(new DummyInteraction("blo", 1), element2);
        simulateEvent(new DummyInteraction("blu", 1), element2);

        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence0 {" +
             "  Sequence sequence1 {" +
             "    Event LeftMouseClick {}" +
             "    Event bla {}" +
             "    Event bli {}" +
             "    Event MiddleMouseClick {}" +
             "    Event blo {}" +
             "    Event blu {}" +
             "  }" +
             "  Sequence sequence2 {" +
             "    Event bla {}" +
             "    Event bli {}" +
             "    Event RightMouseClick {}" +
             "    Event blo {}" +
             "    Event blu {}" +
             "  }" +
             "}", getTaskTree());

        simulateEvent(new MouseButtonDown(leftBtn), element1);
        simulateEvent(new MouseButtonUp(leftBtn), element1);
        simulateEvent(new MouseClick(leftBtn), element2);

        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence0 {" +
             "  Sequence sequence1 {" +
             "    Event LeftMouseClick {}" +
             "    Event bla {}" +
             "    Event bli {}" +
             "    Event MiddleMouseClick {}" +
             "    Event blo {}" +
             "    Event blu {}" +
             "  }" +
             "  Sequence sequence2 {" +
             "    Event bla {}" +
             "    Event bli {}" +
             "    Event RightMouseClick {}" +
             "    Event blo {}" +
             "    Event blu {}" +
             "  }" +
             "  Sequence sequence3 {" +
             "    Event LeftMouseButtonDown {}" +
             "    Event LeftMouseButtonUp {}" +
             "  }" +
             "  Sequence sequence4 {" +
             "    Event LeftMouseClick {}" +
             "  }" +
             "}", getTaskTree());

        simulateEvent(new MouseButtonDown(middleBtn), element1);
        simulateEvent(new MouseButtonUp(middleBtn), element1);
        simulateEvent(new MouseClick(rightBtn), element1);
        simulateEvent(new DummyInteraction("bla", 1), element2);

        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence0 {" +
             "  Sequence sequence1 {" +
             "    Event LeftMouseClick {}" +
             "    Event bla {}" +
             "    Event bli {}" +
             "    Event MiddleMouseClick {}" +
             "    Event blo {}" +
             "    Event blu {}" +
             "  }" +
             "  Sequence sequence2 {" +
             "    Event bla {}" +
             "    Event bli {}" +
             "    Event RightMouseClick {}" +
             "    Event blo {}" +
             "    Event blu {}" +
             "  }" +
             "  Sequence sequence3 {" +
             "    Event LeftMouseButtonDown {}" +
             "    Event LeftMouseButtonUp {}" +
             "  }" +
             "  Sequence sequence4 {" +
             "    Event LeftMouseClick {}" +
             "  }" +
             "  Sequence sequence5 {" +
             "    Sequence sequence6 {" +
             "      Event MiddleMouseButtonDown {}" +
             "      Event MiddleMouseButtonUp {}" +
             "    }" +
             "    Event RightMouseClick {}" +
             "  }" +
             "  Sequence sequence7 {" +
             "    Event bla {}" +
             "  }" +
             "}", getTaskTree());

    }

}
