package de.ugoe.cs.quest.eventcore.gui;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: $
 * @author 2011, last modified by $Author: $
 */
public class MouseClick extends MouseButtonInteraction {

    /**  */
    private static final long serialVersionUID = 1L;

    /**
     * @param button
     */
    public MouseClick(Button button) {
        super(button);
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.harms.attef.userinteraction.Interaction#getName()
     */
    public String getName() {
        if (super.getButton() == Button.LEFT) {
            return "LeftMouseClick";
        }
        else if (super.getButton() == Button.MIDDLE) {
            return "MiddleMouseClick";
        }
        else if (super.getButton() == Button.RIGHT) {
            return "RightMouseClick";
        }
        else {
            return "UnknownMouseButtonClick";
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        if (super.getButton() == Button.LEFT) {
            return "left mouse click";
        }
        else if (super.getButton() == Button.MIDDLE) {
            return "middle mouse click";
        }
        else if (super.getButton() == Button.RIGHT) {
            return "right mouse click";
        }
        else {
            return "unknown mouse button click";
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.harms.attef.userinteraction.Interaction#startsLogicalSequence()
     */
    public boolean startsLogicalSequence() {
        return false;
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.harms.attef.userinteraction.Interaction#finishesLogicalSequence()
     */
    public boolean finishesLogicalSequence() {
        return false;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof MouseClick) {
            return getButton().equals(((MouseClick) obj).getButton());
        }
        return false;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        return getButton().hashCode();
    }
}
