#pragma once

#include "SAXContentHandlerImpl.h"
#include <string>

#include "WindowData.h"

class LogParser : public SAXContentHandlerImpl
{
private:
	static const int defaultMsgDelay = 2000;
	WindowData * currentWindow;
	WindowData * currentParent;

	int msgType;
	LPARAM lParam;
	WPARAM wParam;

	int delay;

	void sendMessage(HWND hwnd);

public:
	LogParser(void);
	~LogParser(void);

	virtual HRESULT STDMETHODCALLTYPE startElement( 
			wchar_t __RPC_FAR *pwchNamespaceUri,
			int cchNamespaceUri,
			wchar_t __RPC_FAR *pwchLocalName,
			int cchLocalName,
			wchar_t __RPC_FAR *pwchRawName,
			int cchRawName,
			MSXML2::ISAXAttributes __RPC_FAR *pAttributes);

	virtual HRESULT STDMETHODCALLTYPE endElement( 
			wchar_t __RPC_FAR *pwchNamespaceUri,
			int cchNamespaceUri,
			wchar_t __RPC_FAR *pwchLocalName,
			int cchLocalName,
			wchar_t __RPC_FAR *pwchRawName,
			int cchRawName);

	std::wstring GetAttributeValue(MSXML2::ISAXAttributes __RPC_FAR *pAttributes,
							   std::wstring name, std::wstring defvalue);


	int getDefaultMsgDelay();
};
