/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.ba.ClassMember;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.ElementValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCIPAnnotationDatabase {
    Map<ClassMember, Map<String, ElementValue>> memberAnnotations = new HashMap<ClassMember, Map<String, ElementValue>>();
    Map<String, Map<String, ElementValue>> classAnnotations = new HashMap<String, Map<String, ElementValue>>();

    public Object getClassAnnotation(String dottedClassName, String annotationClass) {
        assert (dottedClassName.indexOf(47) == -1);
        return this.getEntryForClass(dottedClassName).get(annotationClass);
    }

    public boolean hasClassAnnotation(String dottedClassName, String annotationClass) {
        assert (dottedClassName.indexOf(47) == -1);
        return this.getEntryForClass(dottedClassName).containsKey(annotationClass);
    }

    public Object getFieldAnnotation(XField field, String annotationClass) {
        return this.getEntryForClassMember(field).get(annotationClass);
    }

    public boolean hasFieldAnnotation(XField field, String annotationClass) {
        return this.getEntryForClassMember(field).containsKey(annotationClass);
    }

    public Object getMethodAnnotation(XMethod method, String annotationClass) {
        return this.getEntryForClassMember(method).get(annotationClass);
    }

    public boolean hasMethodAnnotation(XMethod method, String annotationClass) {
        return this.getEntryForClassMember(method).containsKey(annotationClass);
    }

    public Map<String, ElementValue> getEntryForClassMember(ClassMember member) {
        Map<String, ElementValue> map = this.memberAnnotations.get(member);
        if (map == null) {
            map = new HashMap<String, ElementValue>();
            this.memberAnnotations.put(member, map);
        }
        return map;
    }

    public Map<String, ElementValue> getEntryForClass(String dottedClassName) {
        assert (dottedClassName.indexOf(47) == -1);
        Map<String, ElementValue> map = this.classAnnotations.get(dottedClassName);
        if (map == null) {
            map = new HashMap<String, ElementValue>(3);
            this.classAnnotations.put(dottedClassName, map);
        }
        return map;
    }
}

