/*
 * Decompiled with CFR 0.152.
 */
package junitx.util;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestSuite;
import junitx.util.AbstractSuiteBuilder;
import junitx.util.TestFilter;

public class DirectorySuiteBuilder
extends AbstractSuiteBuilder {
    static final int SUFFIX_LENGTH = ".class".length();

    public DirectorySuiteBuilder() {
        this(null);
    }

    public DirectorySuiteBuilder(TestFilter filter) {
        super(filter);
    }

    public Test suite(File directory) throws Exception {
        TestSuite suite = new TestSuite(directory.getName());
        List classnames = this.browse(directory);
        this.merge(classnames, suite);
        return suite;
    }

    public Test suite(String directoryName) throws Exception {
        File dir = new File(directoryName);
        return this.suite(dir);
    }

    protected List browse(File directory) throws Exception {
        Vector result = new Vector();
        this.gatherFiles(directory, result);
        return result;
    }

    private void gatherFiles(File root, List result) throws IOException {
        String path = root.getCanonicalPath();
        this.gather(root, path.length() + 1, result);
    }

    private void gather(File root, int prefix, List result) throws IOException {
        File[] files = root.listFiles();
        if (files == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (file.isDirectory()) {
                if (file.canRead()) {
                    this.gather(file, prefix, result);
                }
            } else if (this.isTestClass(file.getPath())) {
                result.add(this.getClassName(file.getCanonicalPath().substring(prefix)));
            }
            ++i;
        }
    }

    private String getClassName(String filename) {
        return filename.replace(File.separatorChar, '.').substring(0, filename.length() - SUFFIX_LENGTH);
    }
}

