/*
 * Decompiled with CFR 0.152.
 */
package jdepend.framework;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import jdepend.framework.FileManager;
import jdepend.framework.JDepend;
import jdepend.framework.JDependTestCase;
import jdepend.framework.JavaClass;
import jdepend.framework.JavaClassBuilder;

public class JarFileParserTest
extends JDependTestCase {
    private File jarFile;
    private File zipFile;

    public JarFileParserTest(String name) {
        super(name);
    }

    protected void setUp() {
        super.setUp();
        this.jarFile = new File(this.getTestDataDir() + "test.jar");
        this.zipFile = new File(this.getTestDataDir() + "test.zip");
    }

    protected void tearDown() {
        super.tearDown();
    }

    public void testInvalidJarFile() throws IOException {
        JavaClassBuilder builder = new JavaClassBuilder();
        File bogusFile = new File(this.getTestDataDir() + "bogus.jar");
        try {
            builder.buildClasses(bogusFile);
            JarFileParserTest.fail((String)"Should raise IOException");
        }
        catch (IOException expected) {
            JarFileParserTest.assertTrue((boolean)true);
        }
    }

    public void testInvalidZipFile() throws IOException {
        JavaClassBuilder builder = new JavaClassBuilder();
        File bogusFile = new File(this.getTestDataDir() + "bogus.zip");
        try {
            builder.buildClasses(bogusFile);
            JarFileParserTest.fail((String)"Should raise IOException");
        }
        catch (IOException expected) {
            JarFileParserTest.assertTrue((boolean)true);
        }
    }

    public void testJarFile() throws IOException {
        JavaClassBuilder builder = new JavaClassBuilder();
        Collection classes = builder.buildClasses(this.jarFile);
        JarFileParserTest.assertEquals((int)5, (int)classes.size());
        this.assertClassesExist(classes);
        this.assertInnerClassesExist(classes);
    }

    public void testJarFileWithoutInnerClasses() throws IOException {
        FileManager fm = new FileManager();
        fm.acceptInnerClasses(false);
        JavaClassBuilder builder = new JavaClassBuilder(fm);
        Collection classes = builder.buildClasses(this.jarFile);
        JarFileParserTest.assertEquals((int)4, (int)classes.size());
        this.assertClassesExist(classes);
    }

    public void testZipFile() throws IOException {
        JavaClassBuilder builder = new JavaClassBuilder();
        Collection classes = builder.buildClasses(this.zipFile);
        JarFileParserTest.assertEquals((int)5, (int)classes.size());
        this.assertClassesExist(classes);
        this.assertInnerClassesExist(classes);
    }

    public void testZipFileWithoutInnerClasses() throws IOException {
        FileManager fm = new FileManager();
        fm.acceptInnerClasses(false);
        JavaClassBuilder builder = new JavaClassBuilder(fm);
        Collection classes = builder.buildClasses(this.zipFile);
        JarFileParserTest.assertEquals((int)4, (int)classes.size());
        this.assertClassesExist(classes);
    }

    public void testCountClasses() throws IOException {
        JDepend jdepend = new JDepend();
        jdepend.addDirectory(this.getTestDataDir());
        jdepend.analyzeInnerClasses(true);
        JarFileParserTest.assertEquals((int)10, (int)jdepend.countClasses());
        jdepend.analyzeInnerClasses(false);
        JarFileParserTest.assertEquals((int)8, (int)jdepend.countClasses());
    }

    private void assertClassesExist(Collection classes) {
        JarFileParserTest.assertTrue((boolean)classes.contains(new JavaClass("jdepend.framework.ExampleAbstractClass")));
        JarFileParserTest.assertTrue((boolean)classes.contains(new JavaClass("jdepend.framework.ExampleInterface")));
        JarFileParserTest.assertTrue((boolean)classes.contains(new JavaClass("jdepend.framework.ExampleConcreteClass")));
    }

    private void assertInnerClassesExist(Collection classes) {
        JarFileParserTest.assertTrue((boolean)classes.contains(new JavaClass("jdepend.framework.ExampleConcreteClass$ExampleInnerClass")));
    }
}

