package de.ugoe.cs.quest.plugin.jfc;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

import junit.framework.TestCase;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import de.ugoe.cs.quest.eventcore.Event;
import de.ugoe.cs.quest.plugin.jfc.eventcore.JFCEventId;

/**
 * The class <code>EFGReplayIDCalculatorTest</code> contains tests for the class
 * {@link <code>EFGReplayIDCalculator</code>}
 *
 * @pattern JUnit Test Case
 *
 * @generatedBy CodePro at 7/30/12 4:50 PM
 *
 * @author fabian.glaser
 *
 * @version $Revision$
 */
public class JFCReplayIDCalculatorTest extends TestCase {

	/**
	 * Construct new test instance
	 *
	 * @param name the test name
	 */
	public JFCReplayIDCalculatorTest(String name) {
		super(name);
	}

	/**
	 * Run the String calculateReplayID(JFCEvent) method test.
	 *
	 * @throws Exception
	 *
	 * @generatedBy CodePro at 7/30/12 4:58 PM
	 */
	@Test
	public void testCalculateReplayID_1()
		throws Exception {
		Collection<JFCEventId> ignoredEvents = new HashSet<JFCEventId>();
		ignoredEvents.add(JFCEventId.FOCUS_GAINED);
		JFCLogParser parser = new JFCLogParser(ignoredEvents);
		parser.parseFile(new File(ClassLoader.getSystemResource("freemind_trace.xml").getFile()));
		
		Collection<List<Event>> sequences = parser.getSequences();
		Event event = sequences.iterator().next().get(0);
		
		String result = new JFCReplayIDCalculator().calculateReplayID(event);
		assertEquals("e3561778462", result);
	}

	/**
	 * Perform pre-test initialization.
	 *
	 * @throws Exception
	 *         if the initialization fails for some reason
	 *
	 * @generatedBy CodePro at 7/30/12 4:58 PM
	 */
	@Before
	public void setUp()
		throws Exception {
		// add additional set up code here
	}

	/**
	 * Perform post-test clean-up.
	 *
	 * @throws Exception
	 *         if the clean-up fails for some reason
	 *
	 * @generatedBy CodePro at 7/30/12 4:58 PM
	 */
	@After
	public void tearDown()
		throws Exception {
		// Add additional tear down code here
	}

	/**
	 * Launch the test.
	 *
	 * @param args the command line arguments
	 *
	 * @generatedBy CodePro at 7/30/12 4:58 PM
	 */
	public static void main(String[] args) {
		new org.junit.runner.JUnitCore().run(JFCReplayIDCalculatorTest.class);
	}
}

/*$CPS$ This comment was generated by CodePro. Do not edit it.
 * patternId = com.instantiations.assist.eclipse.pattern.testCasePattern
 * strategyId = com.instantiations.assist.eclipse.pattern.testCasePattern.junitTestCase
 * additionalTestNames = 
 * assertTrue = false
 * callTestMethod = true
 * createMain = false
 * createSetUp = false
 * createTearDown = false
 * createTestFixture = false
 * createTestStubs = false
 * methods = 
 * package = de.ugoe.cs.eventbench.efg
 * package.sourceFolder = EventBenchConsoleTest/src
 * superclassType = junit.framework.TestCase
 * testCase = EFGEventIDCalculatorTest
 * testClassType = de.ugoe.cs.eventbench.efg.EFGEventIDCalculator
 */