
package de.ugoe.cs.quest.ui.commands;

import java.security.InvalidParameterException;
import java.util.Collection;
import java.util.List;

import de.ugoe.cs.quest.CommandHelpers;
import de.ugoe.cs.quest.SequenceInstanceOf;
import de.ugoe.cs.quest.eventcore.Event;
import de.ugoe.cs.quest.tasktrees.manager.TaskTreeManager;
import de.ugoe.cs.quest.tasktrees.treeifc.ITaskTree;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.GlobalDataContainer;

/**
 * <p>
 * Command to sort the key interactions in a sequence of events. An example, the sequence
 * to write the upper case D
 * <ul>
 *   <li>press shift key</li>
 *   <li>press D key</li>
 *   <li>release shift key</li>
 *   <li>release D key</li>
 * </ul>
 * 
 * is transformed to the sequence
 * 
 * <ul>
 *   <li>press shift key</li>
 *   <li>press D key</li>
 *   <li>release D key</li>
 *   <li>release shift key</li>
 * </ul>
 * 
 * in which the first pressed key (shift in this case) is always released last. The same is done
 * for the alt and the ctrl keys.
 * 
 * </p>
 * 
 * @author Patrick Harms
 * @version 1.0
 */
public class CMDgenerateTaskTree implements Command {

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.util.console.Command#help()
     */
    @Override
    public String help() {
        return "generateTaskTree <sequences> {<tasktree>}";
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.util.console.Command#run(java.util.List)
     */
    @SuppressWarnings("unchecked")
    @Override
    public void run(List<Object> parameters) {
        String sequencesName;
        String tasktreeName;
        try {
            sequencesName = (String) parameters.get(0);
            if (parameters.size() > 1) {
                tasktreeName = (String) parameters.get(1);
            }
            else {
                tasktreeName = "tasktree";
            }
        }
        catch (Exception e) {
            throw new InvalidParameterException("must provide a sequences name");
        }

        Collection<List<Event>> sequences = null;
        Object dataObject = GlobalDataContainer.getInstance().getData(sequencesName);
        if (dataObject == null) {
            CommandHelpers.objectNotFoundMessage(sequencesName);
            return;
        }
        if (!SequenceInstanceOf.isCollectionOfSequences(dataObject)) {
            CommandHelpers.objectNotType(sequencesName, "Collection<List<Event<?>>>");
            return;
        }

        sequences = (Collection<List<Event>>) dataObject;
        
        ITaskTree taskTree = new TaskTreeManager().createTaskTree(sequences);
        
        if (GlobalDataContainer.getInstance().addData(tasktreeName, taskTree)) {
            CommandHelpers.dataOverwritten(sequencesName);
        }
        
    }

}
