
package de.ugoe.cs.quest.ui.commands;

import java.security.InvalidParameterException;
import java.util.List;

import de.ugoe.cs.quest.CommandHelpers;
import de.ugoe.cs.quest.tasktrees.treeifc.ITaskTree;
import de.ugoe.cs.quest.usability.UsabilityEvaluationManager;
import de.ugoe.cs.quest.usability.UsabilityEvaluationResult;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.GlobalDataContainer;

/**
 * <p>
 * This command performs a usability evaluation based on a task tree. It uses the
 * {@link UsabilityEvaluationManager} for this purpose. Please consult the documentation of the
 * usability evaluation manager for more details.
 * </p>
 * 
 * @author Patrick Harms
 * @version 1.0
 */
public class CMDevaluateUsability implements Command {

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.util.console.Command#help()
     */
    @Override
    public String help() {
        return "evaluateUsability <tasktree> {<evaluationResult>}";
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.util.console.Command#run(java.util.List)
     */
    @Override
    public void run(List<Object> parameters) {
        String tasktreeName;
        String evaluationResult;
        try {
            tasktreeName = (String) parameters.get(0);
            if (parameters.size() > 1) {
                evaluationResult = (String) parameters.get(1);
            }
            else {
                evaluationResult = "usabilityEvaluationResult";
            }
        }
        catch (Exception e) {
            throw new InvalidParameterException("must provide a task tree name");
        }

        Object dataObject = GlobalDataContainer.getInstance().getData(tasktreeName);
        if (dataObject == null) {
            CommandHelpers.objectNotFoundMessage(tasktreeName);
            return;
        }
        if (!(dataObject instanceof ITaskTree)) {
            CommandHelpers.objectNotType(tasktreeName, "ITaskTree");
            return;
        }

        ITaskTree taskTree = (ITaskTree) dataObject;
        
        UsabilityEvaluationResult result =
            new UsabilityEvaluationManager().evaluateUsability(taskTree);
        
        if (GlobalDataContainer.getInstance().addData(evaluationResult, result)) {
            CommandHelpers.dataOverwritten(evaluationResult);
        }
        
    }

}
