package de.ugoe.cs.quest.ui.commands;

import java.security.InvalidParameterException;
import java.util.List;

import de.ugoe.cs.quest.CommandHelpers;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.GlobalDataContainer;

/**
 * <p>
 * Command to start a time.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDstartTimer implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@Override
	public void run(List<Object> parameters) {
		String timerName;
		try {
			timerName = (String) parameters.get(0);
		} catch (Exception e) {
			throw new InvalidParameterException();
		}
		Long time = System.currentTimeMillis();
		if (GlobalDataContainer.getInstance().addData(timerName, time)) {
			CommandHelpers.dataOverwritten(timerName);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public String help() {
		return "startTimer <timerName>";
	}

}
