/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.gui2.Driver;
import edu.umd.cs.findbugs.gui2.GUISaveState;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class FBFileChooser
extends JFileChooser {
    public FBFileChooser() {
        this.addHiddenFileCheckBox();
        assert (EventQueue.isDispatchThread());
        this.setCurrentDirectory(GUISaveState.getInstance().getStarterDirectoryForLoadBugs());
    }

    protected void setFontSize(float size) {
        this.setFont(this.getFont().deriveFont(size));
        this.setFontSizeHelper(this.getComponents(), size);
    }

    protected void setFontSizeHelper(Component[] comps, float size) {
        if (comps.length <= 0) {
            return;
        }
        for (Component comp : comps) {
            comp.setFont(comp.getFont().deriveFont(size));
            if (!(comp instanceof Container)) continue;
            this.setFontSizeHelper(((Container)comp).getComponents(), size);
        }
    }

    public void addNotify() {
        super.addNotify();
        this.setFontSize(Driver.getFontSize());
    }

    private static void workAroundJFileChooserBug() {
        block6: {
            try {
                Border o = UIManager.getBorder("TableHeader.cellBorder");
                Method m = o.getClass().getMethod("setHorizontalShift", Integer.TYPE);
                m.invoke((Object)o, 0);
            }
            catch (NoSuchMethodException e) {
                assert (false);
            }
            catch (InvocationTargetException e) {
                assert (false);
            }
            catch (IllegalAccessException e) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
    }

    public int showOpenDialog(Component parent) {
        assert (EventQueue.isDispatchThread());
        int x = super.showOpenDialog(parent);
        if (SystemProperties.getProperty("os.name").startsWith("Mac")) {
            FBFileChooser.workAroundJFileChooserBug();
        }
        GUISaveState.getInstance().setStarterDirectoryForLoadBugs(this.getCurrentDirectory());
        return x;
    }

    public int showSaveDialog(Component parent) {
        assert (EventQueue.isDispatchThread());
        int x = super.showSaveDialog(parent);
        if (SystemProperties.getProperty("os.name").startsWith("Mac")) {
            FBFileChooser.workAroundJFileChooserBug();
        }
        GUISaveState.getInstance().setStarterDirectoryForLoadBugs(this.getCurrentDirectory());
        return x;
    }

    public int showDialog(Component parent, String approveButtonText) {
        assert (EventQueue.isDispatchThread());
        int x = super.showDialog(parent, approveButtonText);
        if (SystemProperties.getProperty("os.name").startsWith("Mac")) {
            FBFileChooser.workAroundJFileChooserBug();
        }
        GUISaveState.getInstance().setStarterDirectoryForLoadBugs(this.getCurrentDirectory());
        return x;
    }

    private void addHiddenFileCheckBox() {
        final JCheckBox showHiddenFileCheckBox = new JCheckBox("Show Hidden");
        JPanel accessory = new JPanel();
        accessory.setLayout(new FlowLayout());
        accessory.add(showHiddenFileCheckBox);
        this.setAccessory(accessory);
        showHiddenFileCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                FBFileChooser.this.setFileHidingEnabled(!showHiddenFileCheckBox.isSelected());
            }
        });
    }
}

