/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.guitar.util;

import edu.umd.cs.guitar.model.data.EFG;
import edu.umd.cs.guitar.model.data.EventGraphType;
import edu.umd.cs.guitar.model.data.EventType;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public class GraphUtil {
    EFG inputGraph;
    Hashtable<EventType, Vector<EventType>> preds;
    Hashtable<EventType, Vector<EventType>> succs;
    List<EventType> initialEvents = null;

    public GraphUtil(EFG inputGraph) {
        this.inputGraph = inputGraph;
        this.parseFollowRelations();
        this.parseInitialEvents();
    }

    protected void parseInitialEvents() {
        this.initialEvents = new ArrayList<EventType>();
        if (this.inputGraph == null) {
            return;
        }
        List<EventType> eventList = this.inputGraph.getEvents().getEvent();
        for (EventType event : eventList) {
            if (!event.isInitial() || this.preds.get(event) != null) continue;
            this.initialEvents.add(event);
        }
    }

    private void parseFollowRelations() {
        List<EventType> eventList = this.inputGraph.getEvents().getEvent();
        int eventGraphSize = eventList.size();
        EventGraphType eventGraph = this.inputGraph.getEventGraph();
        if (this.inputGraph == null) {
            return;
        }
        this.succs = new Hashtable();
        this.preds = new Hashtable();
        for (int row = 0; row < eventGraphSize; ++row) {
            EventType currentEvent = eventList.get(row);
            Vector<EventType> s = new Vector<EventType>();
            for (int col = 0; col < eventGraphSize; ++col) {
                int relation = eventGraph.getRow().get(row).getE().get(col);
                if (relation != 0) {
                    EventType otherEvent = eventList.get(col);
                    s.add(otherEvent);
                    if (relation == 2 && !otherEvent.getEventId().equals(currentEvent.getEventId())) {
                        Vector<EventType> p = this.preds.get(otherEvent);
                        if (p == null) {
                            p = new Vector();
                        }
                        p.add(currentEvent);
                        this.preds.put(otherEvent, p);
                    }
                }
                this.succs.put(currentEvent, s);
            }
        }
    }

    public LinkedList<EventType> pathToRoot(EventType event) {
        if (this.initialEvents.contains(event)) {
            LinkedList<EventType> path = new LinkedList<EventType>();
            path.add(event);
            return path;
        }
        Vector<EventType> predEventList = this.preds.get(event);
        if (predEventList == null) {
            return null;
        }
        if (predEventList.size() == 0) {
            System.out.println(event.getEventId() + " has empty predEventList");
            return null;
        }
        for (EventType pred : predEventList) {
            LinkedList<EventType> predPathToRoot = this.pathToRoot(pred);
            if (predPathToRoot == null || predPathToRoot.contains(event)) continue;
            predPathToRoot.add(event);
            return predPathToRoot;
        }
        return null;
    }

    public EventType lookupEvent(String eventID) {
        if (this.inputGraph == null) {
            return null;
        }
        List<EventType> lInputEvents = this.inputGraph.getEvents().getEvent();
        for (EventType event : lInputEvents) {
            if (!event.getEventId().equals(eventID)) continue;
            return event;
        }
        return null;
    }
}

