package de.ugoe.cs.quest.commands.usage;

import java.security.InvalidParameterException;
import java.util.List;

import de.ugoe.cs.quest.CommandHelpers;
import de.ugoe.cs.quest.usageprofiles.FirstOrderMarkovModel;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;
import de.ugoe.cs.util.console.GlobalDataContainer;

/**
 * <p>
 * Command to calculate the entropy of first-order Markov models.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDcalcEntropy implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public String help() {
		return "calcEntropy <modelname>";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@Override
	public void run(List<Object> parameters) {
		String modelname = "";
		try {
			modelname = (String) parameters.get(0);
		} catch (Exception e) {
			throw new InvalidParameterException();
		}

		FirstOrderMarkovModel model = null;
		Object dataObject = GlobalDataContainer.getInstance()
				.getData(modelname);
		if (dataObject == null) {
			CommandHelpers.objectNotFoundMessage(modelname);
			return;
		}
		if (!(dataObject instanceof FirstOrderMarkovModel)) {
			CommandHelpers.objectNotType(modelname, "FirstOrderMarkovModel");
			return;
		}
		model = (FirstOrderMarkovModel) dataObject;
		double entropy = model.calcEntropy();
		if (!Double.isNaN(entropy)) {
			Console.println("entropy: " + entropy);
		}
	}

}
