package de.ugoe.cs.quest.plugin.jfc.guimodel;

import de.ugoe.cs.quest.eventcore.guimodel.AbstractDefaultGUIElement;
import de.ugoe.cs.quest.eventcore.guimodel.IGUIElementSpec;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: $
 * @author 2011, last modified by $Author: $
 */
public class JFCGUIElement extends AbstractDefaultGUIElement {
    
    /**  */
    private static final long serialVersionUID = 1L;

    /** the specification of the GUI Element */
    private JFCGUIElementSpec specification;

    /**
     * @param name
     * @param id
     * @param isModal
     */
    public JFCGUIElement(JFCGUIElementSpec specification, JFCGUIElement parent) {
        super(specification, parent);
        this.specification = specification;
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.quest.eventcore.IEventTarget#getPlatform()
     */
    @Override
    public String getPlatform() {
        return "JFC";
    }

    /**
     * TODO: comment
     * 
     * @return
     */
    public String getJavaType() {
        return specification.getType();
    }

    /**
     * @return Returns the name.
     */
    String getName() {
        return specification.getName();
    }

    /**
     * @return the icon
     */
    String getIcon() {
        return specification.getIcon();
    }

    /**
     * @return the index
     */
    int getIndex() {
        return specification.getIndex();
    }

    /**
     * @return the hashCode
     */
    String getElementHash() {
        return specification.getElementHash();
    }

    /**
     * <p>
     * TODO comment
     * </p>
     */
    @Override
    public void updateSpecification(IGUIElementSpec updateSpecification) {
        if (updateSpecification instanceof JFCGUIElementSpec) {
            specification.update(((JFCGUIElementSpec) updateSpecification));
        }
    }
    
    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String getStringIdentifier() {
        String str = this.toString();
        if( getParent()!=null ) {
            return getParent().getStringIdentifier() + "->" + str;
        }
        return str;
    }
    
    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        String str = getElementDescriptor() + "(" + getName() + "," + getElementHash() + "," +
            getIcon() + "," + getIndex() +")";
        return str;
    }
    
    protected String getElementDescriptor() {
        return "Default";
    }

}
